@extends('layouts.app')
@section('content')
    <link href="{{ asset('assets/vendors/dropify/dist/css/dropify.min.css') }}" rel="stylesheet" type="text/css" />

    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <nav class="contactapp-sidebar">
                    <div data-simplebar class="nicescroll-bar">
                        <div class="menu-content-wrap">
                            @if (onCheckSettingAccountEditOrderPickup())
                                <button id="btn_modal_update_order_pickup" type="button" class="btn btn-primary btn-rounded btn-block"
                                    data-bs-toggle="modal" data-bs-target="#modal_update_order_pickup">
                                    Add Order Pickup
                                </button>
                            @endif
                            <button type="button" class="btn btn-outline-primary btn-rounded btn-block mb-4"
                                data-bs-toggle="collapse" href="#searchPlus" role="button" aria-expanded="false"
                                aria-controls="collapseExample">
                                <span class="icon">
                                    <span class="feather-icon">
                                        <i data-feather="search"></i>
                                    </span>
                                    <span class="ms-1">Tìm kiếm</span>
                                </span>
                            </button>

                            <div class="menu-group">

                                @php
                                    $tab_name = config('constans.constans.order_pickup_status');
                                    $tab_status = [
                                        [
                                            'key' => ORDER_PICKUP_STATUS_WAITING,
                                            'title' => $tab_name[ORDER_PICKUP_STATUS_WAITING],
                                            'icon' => 'clock',
                                        ],
                                        [
                                            'key' => ORDER_PICKUP_STATUS_PENDING_CONFIRM,
                                            'title' => $tab_name[ORDER_PICKUP_STATUS_PENDING_CONFIRM],
                                            'icon' => 'cloud',
                                        ],

                                        [
                                            'key' => ORDER_PICKUP_STATUS_CONFIRMED,
                                            'title' => $tab_name[ORDER_PICKUP_STATUS_CONFIRMED],
                                            'icon' => 'check',
                                        ],
                                        [
                                            'key' => ORDER_PICKUP_STATUS_GOING,
                                            'title' => $tab_name[ORDER_PICKUP_STATUS_GOING],
                                            'icon' => 'truck',
                                        ],
                                        [
                                            'key' => ORDER_PICKUP_STATUS_GONE,
                                            'title' => $tab_name[ORDER_PICKUP_STATUS_GONE],
                                            'icon' => 'package',
                                        ],
                                        [
                                            'key' => ORDER_PICKUP_STATUS_PICKED,
                                            'title' => $tab_name[ORDER_PICKUP_STATUS_PICKED],
                                            'icon' => 'check-circle',
                                        ],
                                        [
                                            'key' => ORDER_PICKUP_STATUS_CANCEL,
                                            'title' => $tab_name[ORDER_PICKUP_STATUS_CANCEL],
                                            'icon' => 'x-circle',
                                        ],
                                    ];
                                @endphp
                                <ul class="nav nav-light navbar-nav flex-column">
                                    <li id="order_pickup_status_null" class="order_pickup_status nav-item active"
                                        onclick="onClickOrderPickupStatus()">
                                        <a class="nav-link" href="javascript:void(0);">
                                            <span class="nav-icon-wrap">
                                                <span class="feather-icon">
                                                    <i data-feather="inbox"></i>
                                                </span>
                                            </span>
                                            <span class="nav-link-text">Tất cả</span>
                                        </a>
                                    </li>
                                    @foreach ($tab_status as $key => $tab)
                                        <li id="order_pickup_status_{{ $tab['key'] }}"
                                            class="order_pickup_status nav-item"
                                            onclick="onClickOrderPickupStatus({{ $tab['key'] }})">
                                            <a class="nav-link" href="javascript:void(0);">
                                                <span class="nav-icon-wrap">
                                                    <span class="feather-icon">
                                                        <i data-feather="{{ $tab['icon'] }}"></i>
                                                    </span>
                                                </span>
                                                <span class="nav-link-text">{{ $tab['title'] }}</span>
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>

                        </div>
                    </div>
                </nav>
                <div class="contactapp-content">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="dropdown">
                                    <a class="contactapp-title link-dark" href="javascript:void(0)" role="button">
                                        <h1>Order Pickup</h1>
                                    </a>
                                </div>
                            </div>
                            <div class="contact-options-wrap">
                                <div class="" data-bs-toggle="tooltip" data-placement="top"
                                    data-bs-original-title="Tìm kiểm nâng cao">
                                    <a class="btn btn-icon btn-flush-dark btn-rounded 
                                    flush-soft-hover no-caret d-sm-inline-block d-none"
                                        data-bs-toggle="collapse" href="#searchPlus" role="button" aria-expanded="false"
                                        aria-controls="collapseExample">
                                        <span class="icon">
                                            <span class="feather-icon">
                                                <i data-feather="search"></i>
                                            </span>
                                        </span>
                                    </a>
                                </div>
                                <div class="v-separator d-lg-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                            <div class="hk-sidebar-togglable"></div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="collapse show" id="searchPlus">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-sm-3 mb-3">
                                                    <label class="form-label mb-0">Khoảng thời gian</label>
                                                    <input type="text" class="form-control"
                                                        name="order_pickup_date_range">
                                                </div>
                                                <div class="col-sm-3 mb-3">
                                                    <label class="form-lable">Chi nhánh</label>
                                                    <select class="form-control" name="order_pickup_branch_id">
                                                        <option value="" selected>Tất cả</option>
                                                        @foreach ($branchs as $branch)
                                                            <option value="{{ $branch['branch_id'] }}">
                                                                {{ $branch['branch_name'] }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="col-sm-4 mb-3">
                                                    <label class="form-lable">Tìm kiếm</label>
                                                    <input class="form-control" name="order_pickup_keywords"
                                                        placeholder="Nhập nội dung bạn muốn tìm kiếm">
                                                </div>
                                                <div class="col-sm-2 mb-3">
                                                    <label class="form-lable"></label>
                                                    <button id="btn_export_excel" type="button"
                                                        class="btn btn-primary btn-rounded btn-block">
                                                        <i class="fas fa-file-excel"></i> Xuất file excel
                                                    </button>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="contact-list-view">
                                    <x-spinner id="loading_show_table_content" />
                                    <div id="show_table_content"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal Order Pickup -->
                    <div id="modal_update_order_pickup" class="modal fade add-new-contact" tabindex="-1" role="dialog"
                        aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5>Lên Lịch PickUp cho KANGO</h5>
                                    <button type="button" id="btn_close_modal_order_pickup" class="btn-close"
                                        data-bs-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="row gx-3" id="modal_body_order_pickup"></div>
                                    <div class="row gx-3" id="modal_body_order_cancel_des"></div>
                                    <div class="row gx-3" id="modal_body_order_image"></div>
                                    <div class="row gx-3">
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label class="form-label">Loại xe *</label>
                                                <select class="form-select" name="order_pickup_type">
                                                    @foreach ($vehicles as $key_vehicle => $vehicle)
                                                        <option value="{{ $key_vehicle }}">
                                                            {{ $vehicle }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <small id="error_order_pickup_type" class="text-danger"></small>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label class="form-label">Chi Nhánh *</label>
                                                <select class="form-select" name="branch_id">
                                                    @foreach ($branchs as $branch)
                                                        <option value="{{ $branch['branch_id'] }}">
                                                            {{ $branch['branch_name'] }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <small id="error_branch_id" class="text-danger"></small>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label class="form-label">Thời gian pickup *</label>
                                                <input type="text" class="form-control" name="order_pickup_date_time">
                                                <small id="error_order_pickup_date_time" class="text-danger"></small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row gx-3">
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label class="form-label">Mã AWB *</label>
                                                <input class="form-control" type="text" name="order_pickup_awb" />
                                                <small id="error_order_pickup_awb" class="text-danger"></small>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label class="form-label">Cân nặng *</label>
                                                <input class="form-control" type="number"
                                                    name="order_pickup_gross_weight" />
                                                <small id="error_order_pickup_gross_weight" class="text-danger"></small>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label class="form-label">Số kiện *</label>
                                                <input class="form-control" type="number"
                                                    name="order_pickup_number_packages" />
                                                <small id="error_order_pickup_number_packages"
                                                    class="text-danger"></small>
                                            </div>
                                        </div>
                                    </div>
                                    @if (auth()->user()['position_id'] != getPositionAccountSetting(SETTING_FWD_ACCOUNT))
                                        <div class="col-sm-12 mb-3">
                                            <label class="form-label">Người đặt đơn</label>
                                            <select class="form-control select2" name="" id="fwd_ids">
                                                <option value="" onclick="chooseFwd()">Chọn công ty</option>
                                                @foreach ($fwds as $item)
                                                    <option value="{{ $item['user_id'] }}">
                                                        {{ $item['user_company_name'] }}
                                                        [{{ $item['user_code'] }}]</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    @else
                                        <input class="form-control" value="{{ auth()->id() }}" type="text"
                                            id="fwd_ids" id="fwd_ids" hidden disabled />
                                    @endif
                                    <div class="col-sm-12 mb-3">
                                        <div class="form-group">
                                            <label class="form-label">Tên ngưởi gửi *</label>
                                            <input class="form-control" type="text" name="order_pickup_name"
                                                id="order_pickup_name" />
                                            <small id="error_order_pickup_name" class="text-danger"></small>
                                        </div>
                                    </div>
                                    <div class="row gx-3">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label class="form-label">Số điện thoại *</label>
                                                <input class="form-control" type="number" name="order_pickup_phone" />
                                                <small id="error_order_pickup_phone" class="text-danger"></small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label class="form-label">Địa chỉ *</label>
                                                {{-- <input class="form-control" type="text" name="order_pickup_address"
                                                    id="address_map_google" /> --}}
                                                @include('template.google-map.choose-and-input', [
                                                    'is_inp' => true,
                                                    'is_location' => false,
                                                ])
                                                <small id="error_order_pickup_address" class="text-danger"></small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row gx-3">
                                        <div class="col-sm-12 form-group">
                                            <label class="form-label">Ghi chú</label>
                                            <textarea class="form-control mnh-100p" rows="4" name="order_pickup_note"></textarea>
                                            <small id="error_order_pickup_note" class="text-danger"></small>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer align-items-center justify-content-center">
                                    <button type="button" id="close_order_pickup" class="btn btn-secondary">
                                        Hủy
                                    </button>
                                    <button type="button" id="save_order_pickup" class="btn btn-primary">
                                        Lưu
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal Order Pickup -->

                    <div class="modal fade" id="modalUploadOrderPickupImageBackdrop" tabindex="-1"
                        aria-labelledby="modalUploadOrderPickupImageBackdropLabel" aria-hidden="true"
                        data-order_pickup_id="null" data-order_pickup_status="{{ ORDER_PICKUP_STATUS_PICKED }}"
                        data-bs-backdrop="static" data-bs-keyboard="false">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h1 class="modal-title fs-5" id="modalUploadOrderPickupImageBackdropLabel">
                                        Xác nhận đã pickup
                                    </h1>
                                </div>
                                <div class="modal-body">
                                    <label class="form-label">
                                        Cập nhật hình ảnh
                                    </label>
                                    <input type="file" class="dropify" name="order_pickup_image"
                                        data-allowed-file-extensions="jpg jpeg png" />
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                        Đóng
                                    </button>
                                    <button type="button" class="btn btn-primary" id="btnUploadOrderPickupImage">
                                        Lưu
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Page Body -->

        <!-- Modal -->
        <div class="modal fade" id="addShipperFree" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
            aria-labelledby="addShipperFreeLabel" aria-hidden="true">
            <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="addShipperFreeLabel">Chọn shipper</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" style="min-height: 300px">
                        <div class="col-sm-12 mb-3">
                            <label class="form-label">Chọn shipper</label>
                            <select class="form-control select2" name="" id="add_shipper_id">

                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                        <button type="button" class="btn btn-primary" onclick="onAddShipper()">Xác nhận</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/vendors/xlsx/dist/xlsx.full.min.js') }}"></script>
        <script src="{{ asset('assets/vendors/file-saver/dist/FileSaver.min.js') }}"></script>

        <script src="{{ asset('assets/vendors/dropify/dist/js/dropify.min.js') }}"></script>
        <script src="{{ asset('assets/dist/js/dropify-data.js') }}"></script>

        <script src="{{ asset('js/order-pickup/index.js') }}"></script>
    @endpush
@endsection
