@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <nav class="contactapp-sidebar">
                    <div data-simplebar class="nicescroll-bar">
                        <div class="menu-content-wrap">

                            
                            <div class="mb-3">
                                <div class="dropzone" id="label-dropzone"></div>

                                <div class="my-3">
                                    <label for="">Lựa chọn label</label>
                                    <select id="tabSelect" class="form-select">
                                        <option value="nz_crrio_label" selected>Nz & crrio</option>
                                        <option value="auk_label">Auk</option>
                                        <option value="dpd_label">DPD</option>
                                        <option value="etower_label">UBI CHINA</option>
                                        <option value="top_log_au_label">TOP-LOG-AU</option>
                                    </select>
                                </div>
                                <!-- Tabs -->
                                <ul class="nav nav-tabs d-none" id="myTab" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link active" id="nz_crrio_label-tab" data-bs-toggle="tab"
                                            data-bs-target="#nz_crrio_label" type="button" role="tab"></button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="auk_label-tab" data-bs-toggle="tab"
                                            data-bs-target="#auk_label" type="button" role="tab"></button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="dpd_label-tab" data-bs-toggle="tab"
                                            data-bs-target="#dpd_label" type="button" role="tab"></button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="etower_label-tab" data-bs-toggle="tab"
                                            data-bs-target="#etower_label" type="button" role="tab"></button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="top_log_au_label-tab" data-bs-toggle="tab"
                                            data-bs-target="#top_log_au_label" type="button" role="tab"></button>
                                    </li>
                                </ul>
                                <!-- Tab Panes -->
                                <div class="tab-content mt-4">
                                    <div class="tab-pane fade show active" id="nz_crrio_label" role="tabpanel">
                                        <div class="">
                                            <p class="text-danger">Lưu ý khi upload label:
                                                <br>
                                                - Độ dài của addressLine1 và addressLine2 không được lớn hơn 40
                                                <br>
                                                - city, state, postcode phải được nhập đúng với file excel các vùng
                                            </p>
                                        </div>
                                        <div class="text-center">
                                            <a href="{{ asset('assets/file/csv-sample-cirro.csv') }}">File mẫu Cirro Au</a>
                                        </div>
                                        <div class="text-center">
                                            <a href="{{ asset('assets/file/NZPOST_Zone.xlsx') }}">File Zone NZ</a>
                                        </div>
                                        <div class="text-center">
                                            <a href="{{ asset('assets/file/label-kango-au.xlsx') }}">File mẫu NZ</a>
                                        </div>

                                        <div class="text-center my-3">
                                            <button class="btn w-100 btn-custom btn-primary icon-wthot-bg btn-rounded btn-sm"
                                                id="create_label_nz">
                                                <span>
                                                    <span>Tạo Label NZ && Crrio</span>
                                                    <span class="icon"><i class="fas fa-plus"></i></span>
                                                </span>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="auk_label" role="tabpanel">
                                        <div class="">
                                            <p class="text-danger">Lưu ý khi upload label:
                                                <br>
                                                - File mẫu Auk gồm 2 file: file hướng dẫn và file dữ liệu mẫu
                                                <br>
                                                - <strong>lineCode</strong> và <strong>destination</strong> vui lòng chỉ sử dụng những tên đã cho trong file hướng dẫn
                                            </p>
                                        </div>
                                        <div class="text-center">
                                            <a href="{{ asset('assets/file/FILE_AUK_SAMPLE.zip') }}">File mẫu AUK</a>
                                        </div>

                                        <div class="text-center my-3">
                                            <button class="btn w-100 btn-custom btn-primary icon-wthot-bg btn-rounded btn-sm"
                                                id="create_label_auk">
                                                <span>
                                                    <span>Tạo Label AUK</span>
                                                    <span class="icon"><i class="fas fa-plus"></i></span>
                                                </span>
                                            </button>
                                        </div>

                                    </div>
                                    <div class="tab-pane fade" id="dpd_label" role="tabpanel">
                                        <div class="">
                                            <p class="text-danger">Lưu ý khi upload label:
                                                <br>
                                                - <strong>DPD NL</strong> và <strong>DPD UK</strong> vui lòng chỉ sử dụng những tên dịch vụ này
                                            </p>
                                        </div>
                                        <div class="text-center">
                                            <a href="{{ asset('assets/file/MAU_IMPORT_LABEL_DPD.xlsx') }}">File mẫu DPD</a>
                                        </div>

                                        <div class="text-center my-3">
                                            <button class="btn w-100 btn-custom btn-primary icon-wthot-bg btn-rounded btn-sm"
                                                id="create_label_dpd">
                                                <span>
                                                    <span>Tạo Label DPD</span>
                                                    <span class="icon"><i class="fas fa-plus"></i></span>
                                                </span>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="etower_label" role="tabpanel">
                                        <div class="">
                                            <p class="text-danger">Lưu ý khi upload label:
                                                <br>
                                                - <strong>UBI.AU2AU.PRIORITY</strong> và <strong>UBI.AU2AU.IPEC</strong> vui lòng chỉ sử dụng những tên dịch vụ này
                                            </p>
                                        </div>
                                        <div class="text-center">
                                            <a href="{{ asset('assets/file/MAU_IMPORT_LABEL_ETOWER.xlsx') }}">File mẫu ETOWER</a>
                                        </div>

                                        <div class="text-center my-3">
                                            <button class="btn w-100 btn-custom btn-primary icon-wthot-bg btn-rounded btn-sm"
                                                id="create_label_etower">
                                                <span>
                                                    <span>Tạo Label ETOWER</span>
                                                    <span class="icon"><i class="fas fa-plus"></i></span>
                                                </span>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="top_log_au_label" role="tabpanel">
                                        <div class="">
                                            <p class="text-danger">Lưu ý khi upload label:
                                                <br>
                                                - <strong>TOP-LOG-AU</strong> vui lòng chỉ sử dụng những tên dịch vụ này
                                            </p>
                                        </div>
                                        <div class="text-center">
                                            <a href="{{ asset('assets/file/MAU_IMPORT_LABEL_TOP_LOG_AU.xlsx') }}">File mẫu TOP-LOG-AU</a>
                                        </div>

                                        <div class="text-center my-3">
                                            <button class="btn w-100 btn-custom btn-primary icon-wthot-bg btn-rounded btn-sm"
                                                id="create_label_top_log_au">
                                                <span>
                                                    <span>Tạo Label</span>
                                                    <span class="icon"><i class="fas fa-plus"></i></span>
                                                </span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </nav>
                <div class="contactapp-content">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="my-3 ">
                                    <a class="contactapp-title link-dark">
                                        <h1 class="me-1">Create Labels</h1>
                                    </a>
                                </div>
                            </div>
                            <div class="contact-options-wrap">
                                <div class="v-separator d-lg-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                            <div class="hk-sidebar-togglable"></div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">

                                <div class="contact-list-view">
                                    <div id="datable_1_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                                        <div class="row">
                                            <div class="col-7 mb-3">
                                                <div class="contact-toolbar-left">
                                                    <select id="label_type"
                                                        class="d-flex align-items-center w-130p form-select form-select-sm">
                                                        <option value="">Tất cả</option>
                                                        <option value="AP-NZPOST">AP-NZPOST</option>
                                                        <option value="DPD NL">DPD NL</option>
                                                        <option value="DPD UK">DPD UK</option>
                                                        <option value="AUSPOST">AUSPOST</option>
                                                        <option value="UBI.AU2AU.PRIORITY">UBI.AU2AU.PRIORITY</option>
                                                        <option value="UBI.AU2AU.IPEC">UBI.AU2AU.IPEC</option>
                                                        <option value="TOP-LOG-AU">TOP-LOG-AU</option>
                                                        <option value="AP-SYD-AUPARCELPOST">AP-SYD-AUPARCELPOST</option>
                                                        <option value="AP-DEDHL">AP-DEDHL</option>
                                                        <option value="AP-DE-DHL-INTER">AP-DE-DHL-INTER</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-5 mb-3">
                                                <div class="contact-toolbar-right">
                                                    <div class=""><label><input type="search" id="keywords" 
                                                                class="form-control form-control-sm"
                                                                placeholder="Nhấn 'Enter' để tìm kiếm"></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="" id="content-labels"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>
    @push('scripts')
        <!-- Dropify JS -->

        <script lang="javascript" src="{{ asset('assets/vendors/xlsx/dist/xlsx.full.min.js') }}"></script>
        <script>
            // Hàm mở modal
            function openModal() {
                $('#rulesModal').modal('show');
            }
            $(".select2").select2();

            function onDelete() {
                Swal.fire({
                    title: "Bạn có chắc chắn?",
                    text: "Bạn có muốn ẩn đối tượng này không",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Có",
                    cancelButtonText: "Không"
                }).then((result) => {
                    if (result.isConfirmed) {
                        Swal.fire({
                            title: "Deleted!",
                            text: "Your file has been deleted.",
                            icon: "success"
                        });
                    }
                });
            }

            $(document).ready(function() {
                document.getElementById('tabSelect').addEventListener('change', function() {
                    const selectedTab = this.value;
                    const tabElement = document.getElementById(`${selectedTab}-tab`);
                    const tab = new bootstrap.Tab(tabElement);
                    tab.show();
                });
            })
        </script>

        <script src="{{ asset('js/label-nz/index.js') }}"></script>
    @endpush
@endsection
