<div class="row">
    <div class="col-sm-12 table-responsive">
        <table class="table w-100 mb-5 myDatatable">
            <thead class="thead-primary">
                <tr role="row">
                    <th rowspan="1" colspan="1">NO</th>
                    <th rowspan="1" colspan="1">Date</th>
                    <th rowspan="1" colspan="1">Tracking code</th>
                    <th rowspan="1" colspan="1">Id Label</th>
                    <th rowspan="1" colspan="1">Service</th>
                    <th rowspan="1" colspan="1">State</th>
                    <th rowspan="1" colspan="1">Post Code</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($labels as $key => $value)
                    <tr class="odd">
                        <td>
                            <button onclick="onActionBtnShowClick(this)"
                                class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                                data-bs-toggle="collapse" data-bs-target="#label_{{ $value['label_id'] }}"
                                aria-expanded="false">
                                <span class="icon">
                                    <i class="fa fa-plus"></i>
                                </span>
                            </button>
                        </td>
                        <td>{{ formatFullDate($value['created_at']) }}</td>
                        <td>{{ $value['reference_no'] }}</td>
                        <td class="text-uppercase fw-bold text-primary">
                            @php
                                $check_file = checkFileInfo($value['link']);
                            @endphp
                            @if (isset($check_file) && $check_file['extension'] == 'txt')
                                <a href="javascript:void(0)" onclick="onPrintFile('{{ $value['link'] }}')">
                                    <i class="fas fa-file-pdf"></i>{{ $value['label_code'] }}
                                </a>
                            @else
                                <a href="{{ $value['in_directory'] == IN_DIRECTORY ? asset($value['link']) : $value['link'] }}"
                                    target="_blank" class="">
                                    <i class="fas fa-download"></i>{{ $value['label_code'] }}
                                </a>
                            @endif
                        </td>
                        <td class="fw-bold">
                            {{ $value['service_code'] }}
                        </td>
                        <td class="fw-bold text-primary">
                            {{ $value['state'] }}
                        </td>
                        <td class="fw-bold text-primary">
                            {{ $value['post_code'] }}
                        </td>
                    </tr>
                    <tr class="child collapse" id="label_{{ $value['label_id'] }}">
                        <td class="child" colspan="7">
                            <ul>
                                <li class="mb-3">
                                    <span class="dtr-title fw-bold">Preference Code: </span>
                                    <span class="dtr-data">{{ $value['reference_no'] }}</span>
                                </li>
                                <li class="mb-3">
                                    <span class="dtr-title fw-bold">Người tạo: </span>
                                    @if (isset($value['creater']))
                                        <span class="dtr-data">{{ $value['creater']['user_contact_name'] }}
                                            [{{ $value['creater']['user_code'] }}]
                                        </span>
                                    @else
                                        <span class="dtr-data text-danger">Người tạo không còn tồn tại*</span>
                                    @endif

                                </li>
                            </ul>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
<div class="d-flex justify-content-center mt-3">
    {{ $labels->links('components.pagination') }}
</div>
