@extends('layouts.app')
@section('content')
    <style>
        .ck-editor__editable[role="textbox"] {
            min-height: 400px;
        }
    </style>
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <div class="contactapp-content" style="padding-left: 0px !important">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="dropdown">
                                    <div class="contactapp-title">
                                        <h1>Chỉnh sửa thông báo</h1>
                                    </div>
                                </div>
                            </div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar="init" class="nicescroll-bar">
                                <div class="simplebar-wrapper">
                                    <div class="simplebar-mask">
                                        <div class="simplebar-offset" style="right: 0px; bottom: 0px;">
                                            <div class="simplebar-content-wrapper"
                                                style="height: 100%; overflow: hidden scroll;">
                                                <form class="row m-3">
                                                    <div class="col-12 mb-3">
                                                        <label class="form-label">
                                                            Tiêu đề *
                                                        </label>
                                                        <input type="text" name="notification_title" class="form-control"
                                                            value="{{ $notification['notification_title'] }}" placeholder="Nhập tiêu để">
                                                        <small id="error_notification_title" class="text-danger"></small>
                                                    </div>
                                                    <div class="col-12 mb-3">
                                                        <div class="form-check form-switch">
                                                            <input class="form-check-input" name="notification_important"
                                                                type="checkbox" role="switch" id="flexSwitchNotificationImportant"
                                                                {{ $notification['notification_important'] == NOTIFICATION_IMPORTANT ? 'checked' : '' }}>
                                                            <label class="form-check-label" for="flexSwitchNotificationImportant">
                                                                Thông báo quan trọng
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 mb-3">
                                                        <label class="form-label">
                                                            Nội dung *
                                                        </label>
                                                        <div id="editor"></div>
                                                        <small id="error_notification_content" class="text-danger"></small>
                                                    </div>
                                                    <div class="text-center mt-4">
                                                        <a id="back_to_notifications" href="{{ route('notifications.show') }}"
                                                            class="btn btn-warning text-white">
                                                            Hủy
                                                        </a>
                                                        <button id="submit_edit_notifications" type="button"
                                                            class="btn btn-primary ms-3">
                                                            Xác nhận
                                                        </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>
    @push('scripts')
        <script>
            var notification_id = @json($notification['notification_id']);
            var notification_content = @json($notification['notification_content']);
        </script>
        <script src="{{ asset('assets/vendors/ckeditor5/build/ckeditor.js') }}"></script>
        <script src="{{ asset('js/notifications/edit.js') }}"></script>
    @endpush
@endsection