@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contact-body p-2">
                <div data-simplebar="init" class="nicescroll-bar">
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="card">
                                <img src="{{ asset(isset($notification['user']['user_logo']) ? $notification['user']['user_logo'] : LOGO) }}"
                                    class="card-img-top">
                                <div class="card-body text-center">
                                    <div class="">
                                        <h4>{{ isset($notification['user']['user_company_name']) ? $notification['user']['user_company_name'] : $system_settings[SETTING_COMPANY_NAME]['value'] }}
                                        </h4>
                                    </div>
                                    <div class="">
                                        <span>{{ $notification['user']['user_contact_name'] }}</span>
                                    </div>
                                    <ul class="list-group list-group-flush mt-3">
                                        <li class="list-group-item">
                                            <div class="d-flex justify-content-between">
                                                <h6>Contact Phone</h6>
                                                <span>{{ $notification['user']['user_phone'] }}</span>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="d-flex justify-content-between">
                                                <h6>Email</h6>
                                                <span>{{ $notification['user']['user_name'] }}</span>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="d-flex justify-content-between">
                                                <h6>Hotline</h6>
                                                <span>{{ $system_settings[SETTING_HOTLINE]['value'] }}</span>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-8">
                            <div class="card">
                                <div class="card-header d-flex justify-content-center bg-primary">
                                    <h5 class="text-white">{{ $notification['notification_title'] }}</h5>
                                </div>
                                <div class="card-body">
                                    {!! $notification['notification_content'] !!}
                                </div>
                                <div class="card-footer text-muted d-flex justify-content-between" style="background-color: rgb(243, 243, 243)">
                                    <span>
                                        Ngày đăng: {{ formatFullDate($notification['created_at']) }}
                                    </span>
                                    <span>
                                        {{ formatDateDiffForHumans($notification['created_at']) }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>
@endsection
