<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Airline Label</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }
        .container {
            width: 600px;
            border: 2px solid black;
            padding: 20px;
            text-align: center; /* Căn giữa toàn bộ container */
        }
        .container h1 {
            margin: 0;
            font-size: 24px;
            font-weight: bold;
        }
        .mawb-number,
        .hawb-number {
            font-size: 28px;
            font-weight: bold;
            margin: 10px 0;
            border: 1px solid black; /* Thêm viền cho mã MAWB và HAWB */
            padding: 10px;
        }
        .hawb-number {
            color: red;
        }
        .details {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }
        .column {
            width: 100%;
            border: 1px solid black; /* Thêm viền cho các cột */
            padding: 10px;
            box-sizing: border-box;
            text-align: center; /* Căn giữa cho nội dung trong các cột */;
            margin-bottom: 10px
        }
        .column p {
            margin: 5px 0;
            font-size: 18px;
        }
        .value {
            font-size: 24px;
            font-weight: bold;
        }
        .barcode {
            margin-top: 20px;
            margin-bottom: 20px;
        }
        @media print {
            body {
                margin: 0;
            }
            .container {
                border: none;
                width: 100%;
            }
        }
    </style>
</head>
<body>

    <div class="container">
        <h1>{{ $shipment_tractry->service }}</h1>
        <div class="barcode" style="display: flex; justify-content: center">
            <!-- Barcode placeholder -->
            {!! $barcode !!}
        </div>
        <div class="mawb-number">{{ $shipment_tractry->awb_code }}</div>

        <div class="details">
            <div class="column">
                <p>DEST MAWB</p>
                <p class="value">{{ $shipment_tractry->dest }}</p>
            </div>
            <div class="column">
                <p>TOTAL PCS</p>
                <p class="value">{{ $shipment_tractry->count_package }}</p>
            </div>
        </div>

        <div class="hawb-number">{{ $shipment_tractry->hawb_no }}</div>

        <div class="column">
            <p>DEST HAWB</p>
            <p class="value">{{ $shipment_tractry->dest }}</p>
        </div>
        <div class="column">
            <p>PCS</p>
            <p class="value">{{ $shipment_tractry->count_package }}</p>
        </div>
        <div class="column">
            <p>ORIGIN</p>
            <p class="value">{{ $shipment_tractry->branch_name }}</p>
        </div>
    </div>

    
</body>
</html>
