@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <nav class="contactapp-sidebar">
                    <div data-simplebar class="nicescroll-bar">
                        <div class="menu-content-wrap">
                            <div class="text-center">
                                <a href="https://kango-post.com/view/labelau/csv-tracking.zip">CSV IMPORT SAMPLE</a>
                            </div>

                            <div class="mb-3">
                                <div class="dropzone" id="trackingDropzone"></div>
                                <div class="text-center my-3">
                                    <button id="btn_trackingDropzone"
                                        class="btn btn-custom btn-primary icon-wthot-bg btn-rounded btn-sm">
                                        <span>
                                            <span>Cập nhật mã Tracking</span>
                                            <span class="icon"><i class="fas fa-plus"></i></span>
                                        </span>
                                    </button>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="dropzone" id="dubaiDropzone"></div>
                                <div class="text-center my-3">
                                    <button id="btn_dubaiDropzone"
                                        class="btn btn-custom btn-primary icon-wthot-bg btn-rounded btn-sm">
                                        <span>
                                            <span>Cập nhật mã DUBAI AUE</span>
                                            <span class="icon"><i class="fas fa-plus"></i></span>
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </nav>
                <div class="contactapp-content">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="my-3 ">
                                    <a class="contactapp-title link-dark">
                                        <h1 class="me-1">Shipment:</h1>
                                        <span>{{ $shipment_tractry->awb_code }}</span>
                                    </a>
                                </div>

                                <div class="dropdown ms-3">
                                    <div class="dropdown-menu" style="">
                          
                                    </div>
                                </div>
                            </div>

                            <div class="contact-options-wrap">
                                <div class="" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Dịch Vụ: KSN-US">
                                    <a class="btn btn-icon btn-flush-dark btn-rounded 
                                    flush-soft-hover no-caret d-sm-inline-block d-none"
                                        data-bs-toggle="collapse" href="#searchPlus" role="button" aria-expanded="true"
                                        aria-controls="collapseExample">
                                        <span class="icon">
                                            <span class="feather-icon">
                                                <i data-feather="download"></i>
                                            </span>
                                        </span></a>
                                </div>
                                <div class="v-separator d-lg-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                            <div class="hk-sidebar-togglable"></div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="collapse show" id="searchPlus">
                                    <div class="card card-body">
                                        <div class="d-flex flex-wrap">
                                            <button class="btn btn-primary m-1" onclick="onExportExcel('manifest_au_24c', '{{ $shipment_tractry['awb_code'] }}')">
                                                <i class="fa fa-download"></i> MANIFEST AU 24C
                                            </button>
                                            <button class="btn btn-primary m-1" onclick="onExportExcel('manifest_au_auk', '{{ $shipment_tractry['awb_code'] }}')">
                                                <i class="fa fa-download"></i> MANIFEST AU AUK
                                            </button>
                                            <button class="btn btn-primary m-1" onclick="onExportExcel('manifest_au_solid', '{{ $shipment_tractry['awb_code'] }}')">
                                                <i class="fa fa-download"></i> MANIFEST AU SOLID
                                            </button>
                                            <button class="btn btn-primary m-1" onclick="onExportExcel('manifest_ca_fb_triple', '{{ $shipment_tractry['awb_code'] }}')">
                                                <i class="fa fa-download"></i> MANIFEST_CA FB + TRIPLE
                                            </button>
                                            <button class="btn btn-primary m-1" onclick="onExportExcel('manifest_elc_us', '{{ $shipment_tractry['awb_code'] }}')">
                                                <i class="fa fa-download"></i> MANIFEST_ELC US
                                            </button>
                                            <button class="btn btn-primary m-1" onclick="onExportExcel('manifest_ibc_us', '{{ $shipment_tractry['awb_code'] }}')">
                                                <i class="fa fa-download"></i> MANIFEST_IBC US
                                            </button>
                                            <button class="btn btn-primary m-1" onclick="onExportExcel('manifest_ubi_us', '{{ $shipment_tractry['awb_code'] }}')">
                                                <i class="fa fa-download"></i> MANIFEST_UBI US
                                            </button>
                                            <button class="btn btn-primary m-1" onclick="onExportExcel('universal_london_custom_manifest_lhr', '{{ $shipment_tractry['awb_code'] }}')">
                                                <i class="fa fa-download"></i> UNIVERSAL - LONDON CUSTOM MANIFEST  LHR
                                            </button>
                                            <button class="btn btn-primary m-1" onclick="onExportExcel('universal_uds_format_file_lhr', '{{ $shipment_tractry['awb_code'] }}')">
                                                <i class="fa fa-download"></i> UNIVERSAL - UDS Format File LHR
                                            </button>
                                            <button class="btn btn-primary m-1" onclick="onExportExcel('xborder_bbv_b2c_ams', '{{ $shipment_tractry['awb_code'] }}')">
                                                <i class="fa fa-download"></i> XBORDER - BBV-B2C- AMS
                                            </button>
                                        </div>

                                    </div>
                                </div>
                                <div class="contact-list-view">
                                    <div id="datable_1_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                                        <div class="row">
                                            <div class="col-7 mb-3">
                                                <div class="contact-toolbar-left">
                                                    <select
                                                        class="d-flex align-items-center w-130p form-select form-select-sm">
                                                        <option selected="">Tất cả</option>
                                                        <option value="1">Released</option>
                                                        <option value="0">Not released</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-5 mb-3">
                                                <div class="contact-toolbar-right">
                                                    <div id="" class=""><label><input type="search"
                                                                class="form-control form-control-sm" placeholder="Search"
                                                                id="keywords"></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="" id="content">

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>
    @push('scripts')
        <!-- Dropify JS -->

        <script lang="javascript" src="{{ asset('assets/vendors/xlsx/dist/xlsx.full.min.js') }}"></script>
        <script src="{{ asset('assets/vendors/file-saver/dist/FileSaver.min.js') }}"></script>

        <script>
            let sm_tracktry_id = `{{ $shipment_tractry['sm_tracktry_id'] }}`
            $(".select2").select2();

            function onDelete() {
                Swal.fire({
                    title: "Bạn có chắc chắn?",
                    text: "Bạn có muốn ẩn đối tượng này không",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Có",
                    cancelButtonText: "Không"
                }).then((result) => {
                    if (result.isConfirmed) {
                        Swal.fire({
                            title: "Deleted!",
                            text: "Your file has been deleted.",
                            icon: "success"
                        });
                    }
                });
            }
        </script>
        <script src="{{ asset('js/mawb/bill-shipment.js') }}"></script>
    @endpush
@endsection
