<div class="col-md-12 mt-3">
    <table class="table ">
        <thead class="thead-dark">
            <tr>
                <th style="color:#ffffff">NO</th>
                <th style="color:#ffffff">ID</th>
                <th style="color:#ffffff">Date</th>
                <th style="color:#ffffff">Address</th>
                <th style="color:#ffffff">Status</th>
                <th style="color:#ffffff"></th>

            </tr>
        </thead>
        <tbody>
            @foreach ($pg_trackings as $key => $value)
                @php
                    $package = [
                        "package_tracking_id" => $value['package_tracking_id'],
                        "package_code" => $value['package_code'],
                        "package_tracking_date" => $value['package_tracking_date'],
                        "package_tracking_address" => $value['package_tracking_address'],
                        "package_tracking_note" => $value['package_tracking_note'],
                    ];
                @endphp
                <tr>
                    <td>{{ $key + 1 }}</td>
                    <td class="fw-bold text-primary">
                        <a class="fw-bold text-primary"
                            href="{{ getUrlTracking($value['package_code']) }}" target="_blank">
                            {{ $value['package_code'] }} 
                            <i class="ms-1 fas fa-map-marker-alt"></i>
                        </a>
                    </td>
                    <td>{{ formatFullDate($value->package_tracking_date) }}</td>
                    <td>{{ $value->package_tracking_address }}</td>
                    <td>{{ $value->package_tracking_note }}</td>
                    <td>
                        <button class="btn btn-icon btn-soft-info"
                        onclick="onUpdatePackageTracking({{ json_encode($package) }})"><span class="icon"><i
                                    class="fa fa-edit"></i></span></button>
                        <button class="btn btn-icon btn-soft-danger"
                        onclick="onDeletePackageTracking({{ $value['package_tracking_id'] }})"><span class="icon"><i
                                    class="fa fa-trash"></i></span></button>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="text-center">
    {{ $pg_trackings->links('components.pagination') }}
</div>
