@extends('layouts.app')
@section('content')
    <style>
        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .spin-animation {
            animation: spin 1s linear infinite;
        }
    </style>
    <div class="hk-pg-wrapper">
        <div class="m-3">

            <div class="hk-pg-header pg-header-wth-tab ">
                <div class="w-100">
                    <div class="d-flex align-items-center">
                        <div class="my-3">
                            <a class="contactapp-title link-dark">
                                <h1>Add tracking</h1>
                            </a>
                            <p>Mã MAWB: {{ $shipment_tractry->awb_code }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="hk-pg-body">
                <div class="">
                    <div class="card card-body mt-3">
                        <form id="form_tracking_status" class="col row">
                            <div class="col-4 form-group">
                                <label for="">Address </label>
                                <input type="text" name="tracking_status_address" id="tracking_status_address"
                                    class="form-control" placeholder="Address">
                                <small class="text-danger" id="tracking_status_address_err"></small>
                            </div>
                            <div class="col-md-4 form-group">
                                <label for="">Status </label>
                                <input type="text" name="tracking_status_note" id="tracking_status_note"
                                    class="form-control" placeholder="Status">
                                <small class="text-danger" id="tracking_status_note_err"></small>
                            </div>
                            <div class="col-md-4 form-group">
                                <div class="form-group ">
                                    <label for="">Select date time</label>
                                    <input type="datetime-local" name="tracking_status_date" id="tracking_status_date"
                                        class="form-control ">
                                    <small class="text-danger" id="tracking_status_date_err"></small>
                                </div>
                            </div>
                            <div class="col-md-12 text-end">
                                <button type="submit" name="btn_submit" id="btn_submit_create" class="btn btn-dark">Thêm
                                    Thêm trạng thái</button>
                            </div>
                        </form>
                    </div>
                    <div class="text-center">
                        <button type="submit" class="btn btn-success" onclick="updateStatusHawbByMawb()">
                            <i id="spinIcon" class="fas fa-sync-alt"></i>
                            Cập nhật lại HAWB theo MAWB
                        </button>
                    </div>
                    <div class="row">
                        <div class="container-fluid">
                            <div class="col-md-12 mt-3" id="content">
                            </div>

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    @push('scripts')
        <!-- Dropify JS -->
        <script src="{{ asset('assets/vendors/dropify/dist/js/dropify.min.js') }}"></script>
        <script src="{{ asset('assets/dist/js/dropify-data.js') }}"></script>

        <script>
            // Hàm mở modal
            function openModal() {
                $('#rulesModal').modal('show');
            }
            $(".select2").select2();
            let _loadBtn = true;

            function onLoadBtn() {
                var icon = document.getElementById("spinIcon");
                if (_loadBtn) {
                    icon.classList.add("spin-animation");
                    _loadBtn = false;
                } else {
                    icon.classList.remove("spin-animation");
                    _loadBtn = true;
                }
            }
            let pub_shipment_tracktry_id = @json($shipment_tractry->sm_tracktry_id);
            console.log(pub_shipment_tracktry_id);
            
        </script>
        <script src="{{ asset('js/mawb/add-tracking.js') }}"></script>
    @endpush
@endsection
