@extends('layouts.app')
@section('content')
    <style>
        .swal2-html-container {
            margin-left: 1rem !important;
            margin-right: 1rem !important;
        }
    </style>
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <div class="contactapp-content" style="padding-left: 0px !important">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="dropdown">
                                    <a class="contactapp-title link-dark">
                                        <h1>Áp Kpi Sale</h1>
                                    </a>
                                </div>
                                <div class="dropdown ms-3">
                                    <button type="button" id="openModalAddKpi" class="btn btn-sm btn-outline-secondary"
                                        data-bs-toggle="modal" data-bs-target="#modalAddKpi">Thêm KPI</button>
                                </div>
                            </div>
                            <div class="contact-options-wrap">
                                <a class="btn btn-primary" data-bs-toggle="offcanvas" href="#offcanvasExample"
                                    role="button" aria-controls="offcanvasExample" onclick="showUserWithKpi()">
                                    Áp KPI cho Sale
                                </a>
                                <div class="v-separator d-lg-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                        </header>

                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="contact-list-view">
                                    <div id="datable_1_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                                        <div class="row justify-content-between">
                                            <div class="col mb-3">
                                                <div class="contact-toolbar-left">
                                                    <select class="form-select" id="set_time_kind">
                                                        <option selected>Tất cả loại KPI</option>
                                                        <option value="{{ NO_TIME_RANGE }}">Không giới hạn</option>
                                                        <option value="{{ HAVE_TIME_RANGE }}">Có thời gian</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col mb-3">
                                                <div class="contact-toolbar-right">
                                                    <div id="" class=""><label><input type="search"
                                                                id="keywords" class="form-control form-control-sm"
                                                                placeholder="Search"></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row" id="content">

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>

    <div class="offcanvas offcanvas-start w-75" tabindex="-1" id="offcanvasExample"
        aria-labelledby="offcanvasExampleLabel">
        <div class="offcanvas-header border-bottom bg-primary">
            <h5 class="offcanvas-title text-white" id="offcanvasExampleLabel">Danh sách sale</h5>
            <button type="button" class="btn btn-gradient-danger mb-0" data-bs-dismiss="offcanvas"
                aria-label="Close">Đóng</button>
        </div>
        <div class="offcanvas-body">
            <div class="blogapp-content">
                <div class="blogapp-detail-wrap">
                    <div class="blog-body">
                        <div data-simplebar class="nicescroll-bar">
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-xxl-3 col-lg-4">
                                        <div class="content-aside">
                                            <div class="card card-border">
                                                <div class="card-body">
                                                    <form class="edit-post-form">
                                                        <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                                                            <span>Hiển thị</span>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="form-label">Liên kết KPI</label>
                                                            <select class="form-select" name="show_user_kind"
                                                                id="show_user_kind">
                                                                <option value="" selected>Tất cả</option>
                                                                <option value="0">Chưa liên kết</option>
                                                                <option value="1">Đã liên kết</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="form-label">Team sale</label>
                                                            <select class="form-select" name="show_user_team"
                                                                id="show_user_team">
                                                                <option value="" selected>Tất cả</option>
                                                                <option value="2">Chưa có team</option>
                                                                <option value="{{ SALE_LEADER }}">Leader</option>
                                                                <option value="{{ SALE_MEMBER }}">Member</option>
                                                            </select>
                                                        </div>
                                                        <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                                                            <span>Hành động</span>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="form-label">Chức năng</label>
                                                            <select class="form-select" name="action_kind" id="action_kind">
                                                                <option value="0" selected>Chọn chức năng</option>
                                                                <option value="1">Xóa liên kết KPI</option>
                                                                <option value="2">Liên kết KPI</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="form-label">Chọn KPI liên kết *</label>
                                                            <select class="form-select select2" id="select_kpi">
                                                                <option selected>Chọn KPI</option>
                                                            </select>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                            <button type="button" id="btn-connect-kpi" onclick="onConfirmActionSale()"
                                                class="btn btn-primary btn-block mt-3 mb-3">
                                                Xác nhận
                                            </button>

                                        </div>
                                    </div>
                                    <div class="col-xxl-9 col-lg-8">
                                        <div class="row">
                                            {{-- <div class="col-4">
                                                <label for="">Tìm kiếm theo</label>
                                                <select class="form-select" id="key_search_user">
                                                    <option value="1">Tài khoản</option>
                                                    <option value="0">Loại KPI</option>
                                                </select>
                                            </div> --}}
                                            <div class="col-12">
                                                <label for="">Từ khóa</label>
                                                <div class="input-group mb-3">
                                                    <span class="input-affix-wrapper">
                                                        <input type="text" class="form-control" id="keywords-user"
                                                            placeholder="Nhấn 'Enter' để tìm kiếm">
                                                        <span class="input-suffix"><i class="fa fa-search"></i></span>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="content_users">

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="modalAddKpi" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="modalAddKpiLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="modalAddKpiLabel">Thêm kpi</h1>
                    <button type="button" class="btn-close" id="closeModalAddKpi" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="mx-3">
                    
                </div>
                <div class="modal-body">
                    <div class="title title-xs title-wth-divider text-primary text-uppercase my-4"><span>Cài đặt
                        kpi</span></div>

                <div class="mb-3">
                    <label for="kpi_name" class="form-label">Tiêu đề</label>
                    <input type="email" class="form-control" id="kpi_name" aria-describedby="kpi_name">
                    <div id="kpi_name_err" class="form-text text-danger"></div>
                </div>
                <div class="">
                    <div class="form-check form-switch mb-3">
                        <label class="form-check-label" for="kpi_time_range">Bật giới hạn thời gian</label>
                        <input class="form-check-input" type="checkbox" role="switch" id="set_kpi_time_range">
                    </div>
                    <div class="input-group mb-3" id="display_range_time">
                        <input type="date" class="form-control" id="kpi_time_start">
                        <span class="input-group-text"><i class="fas fa-arrow-right"></i></span>
                        <input type="date" class="form-control" id="kpi_time_end">
                    </div>
                    <div id="set_kpi_time_range_err" class="form-text text-danger"></div>
                </div>

                <div class="title title-xs title-wth-divider text-primary text-uppercase my-4"><span>Cài đặt các
                        mốc</span></div>
                    <div data-bs-spy="scroll" class="me-3" id="display-item-kpi">
                    </div>
                    <small id="display_item_kpi_err" class="form-text text-danger"></small><br>
                </div>
                <a href="#" class="d-inline-flex align-items-center mx-3" onclick="addItemRangeApi()">
                    <i class="ri-add-box-line me-1"></i> Thêm mốc doanh thu
                </a>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"
                        id="close-modal-team">Đóng</button>
                    <button type="button" class="btn btn-primary" id="btn-save-kpi" onclick="onCreateOrUpdate()">Xác
                        nhận</button>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            $(".select2").select2();
        </script>
        <script src="{{ asset('js/manage/sale/kpis.js') }}"></script>
    @endpush
@endsection
