@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <div class="contactapp-content"style="padding-left: 0px !important">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="dropdown">
                                    <a class="contactapp-title link-dark">
                                        <h1>LỊCH SỬ HÓA ĐƠN CHỈNH SỬA NGÀY</h1>
                                    </a>
                                    <small>Thời gian tạo bill : {{ formatFullDate($shipment['created_at']) }}</small>
                                </div>

                            </div>
                            <div class="contact-options-wrap">
                                <div class="">
                                    <small>Mã BILL: {{ $shipment['shipment_code'] }}</small> <br>
                                    <small>Sale name: {{ $shipment['user_contact_name'] }}</small>
                                </div>
                                <div class="v-separator d-lg-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                        </header>
                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="contact-list-view">
                                    <div id="datable_1_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                                        <div class="row justify-content-between">
                                            <div class="col-4 mb-3">
                                                <div class="contact-toolbar-left">
                                                    <input type="date" name="" value="" class="form-control"
                                                        id="edit_at">
                                                </div>
                                            </div>
                                            <div class="col-5 mb-3">
                                                <div class="contact-toolbar-right">
                                                    <div id="" class=""><label><input type="search"
                                                                class="form-control form-control-sm"
                                                                placeholder="nhấn 'Enter' để tìm kiếm"
                                                                id="keywords"></label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3 mb-3">
                                                <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                                    data-bs-target="#exampleModal">
                                                    Cập nhật ngày tạo
                                                </button>
                                            </div>
                                        </div>
                                        <div class="" id="content"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- /Page Body -->
        <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="exampleModalLabel">Cập nhật ngày tạo</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <label for="">Ngày tạo đơn</label>
                        <input type="datetime-local" name="" id="created_at" class="form-control mb-3">
                        <p>Ngày tạo đơn hiện tại là <span class="fw-bold"
                                id="now_created_at">{{ $shipment['created_at'] }}</span></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">đóng</button>
                        <button type="button" class="btn btn-primary"
                            onclick="updateCreatedAt({{ $shipment['shipment_code'] }})">Xác nhận</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            let pub_limit = 10;
            let pub_page = 1;
            fetchData()

            function fetchData() {
                let url = window.location.origin + '/manages/sale/history-edit/list';
                let data = {
                    shipment_id: @json($shipment['shipment_id']),
                    paginate: {
                        page: pub_page,
                        limit: pub_limit
                    },
                    filters: {
                        edit_at: $('#edit_at').val(),
                        keywords: $('#keywords').val()
                    }
                }

                ajaxPostHTML(url, data, 'content');
            }


            $('#edit_at').change(function() {
                fetchData();
            })

            $(document).on('click', '.pagination a', async function(event) {
                event.preventDefault();
                pub_page = $(this).attr('href').split('page=')[1];
                await fetchData();

            });
            $('#keywords').on('keypress', function(e) {
                if (e.which === 13) { // 13 là mã ASCII của phím Enter
                    fetchData();
                }
            })

            async function updateCreatedAt(code) {
                try {
                    const url = window.location.origin + '/manages/sale/update-created_at'
                    const data = {
                        shipment_code: code,
                        date: $('#created_at').val(),
                    }

                    let res = await ajaxContants2(url, 'POST', data);

                    if (res.status === 200) {
                        fetchData();
                        $('#now_created_at').html(res.created_at);
                    }
                    showMessage(res.message)
                } catch (error) {
                    showMessage();
                }
            }
        </script>
    @endpush
@endsection
