<div class="refresh-container">
    <div class="loader-pendulums"></div>
</div>
<div class="card-header rounded bg-primary card-header-action">
    <h5 class="card-title fw-bold text-white">
        Team member ({{ count($sale_team) }} thành viên)
    </h5>
    <div class="card-action-wrap">
        <a class="btn btn-xs btn-icon btn-rounded btn-flush-dark flush-soft-hover text-white" data-bs-toggle="collapse"
            href="#collapse_3" aria-expanded="true"><span class="icon"><span class="feather-icon"><i
                        data-feather="chevron-down"></i></span></span></a>
    </div>
</div>
<div id="collapse_3" class="collapse show">
    <div class="card-body">
        <div class="mb-3">
            <table class="table table-hover mb-0">
                <thead>
                    <tr>
                        <th scope="col">Tên thành viên </th>
                        <th scope="col">KPI</th>
                        <th scope="col">Lợi nhuận thực tế</th>
                        <th scope="col">FWD Weight </th>
                        <th scope="col">FWD Cost </th>
                        <th scope="col"></th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($sale_team as $key => $sale_member)
                        <tr>
                            <td class="">
                                @if (isGetAllData())
                                    <a
                                        href="{{ route('manages.sale.detail', ['sale_code' => $sale_member['user_code']]) }}">
                                        {{ $sale_member['user_contact_name'] }}</a>
                                @else
                                    <p class="text-primary">{{ $sale_member['user_contact_name'] }}</p>
                                @endif

                            </td>
                            @if (isset($sale_member['note']))
                                <td colspan="5" class="text-danger text-sm">
                                    *{{ $sale_member['note'] }}
                                </td>
                            @else
                                <td>
                                    {{ $sale_member['range_kpi_name'] }}
                                </td>
                                <td class="">
                                    {{ number_format($sale_member['total_profit']) }} vnd
                                </td>
                                <td class="">
                                    {{ number_format($sale_member['total_weight']) }}
                                    kg
                                </td>
                                <td class="">
                                    {{ number_format($sale_member['fwd_cost']) }}
                                    VND
                                </td>
                                <td class="">
                                    {{-- <button
                                        class="btn btn-danger btn-sm">
                                        <i class="fa fa-trash"></i>
                                    </button> --}}
                                </td>
                            @endif
                        </tr>
                    @endforeach


                </tbody>
            </table>
        </div>
        <div class="text-end">
            {{-- <button class="btn btn-primary">
                <i class="fa fa-plus"></i>
                Thêm thành viên
            </button> --}}
        </div>
        <div class="row mb-3">
            <div class="col-md-4">
                <div class="card shadow card-border text-center">
                    <div class="card-body">
                        <h5 class="app-name">Lợi
                            nhuận</h5>
                        <div class="app-cat fw-bold" id="team_profit">
                            {{ number_format($total_team['team_profit']) }}
                            VND
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card shadow card-border text-center">
                    <div class="card-body">

                        <h5 class="app-name">FWD
                            Weight</h5>
                        <div class="app-cat text-dark fw-bold" id="team_fwd_weight">
                            {{ $total_team['team_fwd_weight'] }}
                            KG
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card shadow card-border text-center">
                    <div class="card-body">
                        <h5 class="app-name">FWD
                            Cost
                        </h5>
                        <div class="app-cat text-success fw-bold" id="team_fwd_cost">
                            {{ $total_team['team_fwd_weight'] }}
                            VND
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
