<div class="mb-3 row">
    @foreach ($teams as $key => $value)
        <div class="col-lg-12 col-sm-12">
            <div class="card card-refresh">
                <div class="refresh-container">
                    <div class="loader-pendulums"></div>
                </div>
                <div class="card-header card-header-action">
                    <div class="card-title">
                        <a class="h5" href="{{ route('manages.sale.detail', ['sale_code' => $value->user_code]) }}">
                            <i class="fas fa-user-tie"></i>
                            {{ $value->user_contact_name }}
                        </a>
                        <p class="small">Ngày tạo: {{ $value->created_at }}</p>
                    </div>
                    <div class="card-action-wrap">
                        @if (isGetAllData())
                            <button class="btn btn-icon btn-flush-primary btn-sm" data-bs-toggle="modal"
                                data-bs-target="#modalAddLeader"
                                onclick="modalAddLeader(false, {{ $value->sale_team_id }}, 'Team leader {{ $value->user_contact_name }}')">
                                <span class="icon"><i class="fas fa-user-plus"></i></span></button>
                        @endif
                        <div class="d-flex dropdown">
                            <a class="btn btn-xs btn-icon btn-rounded btn-flush-dark flush-soft-hover dropdown dropdown-toggle no-caret"
                                data-bs-toggle="dropdown" href="#" aria-expanded="false"><span class="icon"><i
                                        class="fas fa-cog"></i></span></a>
                            <div class="dropdown-menu">
                                @if (isGetAllData())
                                    <a class="dropdown-item"
                                        href="{{ route('manages.sale.detail', ['sale_code' => $value->user_code]) }}">
                                        <i class="fas fa-user-cog"></i> Thông tin chi tiết
                                    </a>
                                    <a class="dropdown-item" onclick="onDeleteTeam({{ $value->sale_team_id }})">
                                        <i class="fas fa-trash"></i> Xóa
                                    </a>
                                @endif
                                <a class="dropdown-item" onclick="onExportSaleTeam({{ $value['sale_team_id'] }})">
                                    <i class="fas fa-download"></i> Export dữ liệu
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="collapse_{{ $value->sale_team_id }}" class="collapse show">
                    <div class="card-body table-responsive">
                        <table class="table table-hover table-striped mb-0">
                            <thead>
                                <tr>
                                    <th class="fw-bold">Tên</th>
                                    <th class="fw-bold">Mã</th>
                                    <th class="fw-bold">Lợi nhuận</th>
                                    @if (!$check_edit)
                                        <th></th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (getTeamMember($value->sale_team_id, $filters) as $key => $member)
                                    <tr>
                                        @php
                                            $check_leader = $member['member_kind'] == SALE_LEADER;
                                        @endphp
                                        <td class="{{ $check_leader ? 'fw-bold' : '' }}">
                                            @if (isGetAllData())
                                                <a
                                                    href="{{ route('manages.sale.detail', ['sale_code' => $member['user_code']]) }}">
                                                    <i class="{{ $check_leader ? 'fas fa-user-tie' : '' }}"></i>
                                                    {{ $member['user_contact_name'] }}
                                                </a>
                                            @else
                                                <span>
                                                    <i $check_leader ? 'fas fa-user-tie' : '' }}"></i>
                                                    {{ $member['user_contact_name'] }}
                                                </span>
                                            @endif

                                        </td>
                                        <td>{{ $member['user_code'] }}</td>
                                        <td class="fw-bold text-success">
                                            {{ number_format($member['member_profit']) }} VND
                                        </td>
                                        @if (!$check_edit)
                                            <td class="">
                                                <div class="hstack flex-wrap gap-3 pb-0">
                                                    @if ($member['member_kind'] == SALE_MEMBER)
                                                        <button class="btn btn-icon btn-soft-primary btn-sm"
                                                            onclick="changeMemberToLeader({{ $value->sale_team_id }}, {{ $member['sale_member_id'] }})">
                                                            <span class="icon"><i
                                                                    class="fas fa-user-tie"></i></span></button>
                                                        <button class="btn btn-icon btn-soft-info btn-sm"
                                                            onclick="transferMemberToTeam({{ $value->sale_team_id }}, {{ $member['sale_member_id'] }})">
                                                            <span class="icon"><i
                                                                    class="fas fa-reply"></i></span></button>
                                                        <button class="btn btn-icon btn-soft-danger btn-sm"
                                                            onclick="kickMemberOutOfTeam({{ $value->sale_team_id }}, {{ $member['sale_member_id'] }})">
                                                            <span class="icon"><i
                                                                    class="fas fa-sign-out-alt"></i></span></button>
                                                    @endif
                                                </div>
                                            </td>
                                        @endif
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
</div>
<div class="text-center">
    {{ $teams->links('components.pagination') }}
</div>
