<div class="row">
    <div class="col-sm-12 table-responsive">
        <table id="datable_1" class="table w-100 mb-5 no-footer">
            <thead class="thead-primary">
                <tr role="row">
                    <th class="text-white" rowspan="1" colspan="1"></th>
                    <th tabindex="0" rowspan="1" colspan="1">Date </th>
                    <th tabindex="0">ID Bill</th>
                    <th colspan="1">Chi nhánh</th>
                    <th>Dịch vụ</th>
                    <th class="text-white" colspan="1">
                        Người nhận</th>
                    <th class="text-white" colspan="1">Số
                        kiện</th>
                    <th class="text-white" colspan="1">
                        Charge Weight</th>
                    <th class="text-white" colspan="1">
                        Tổng đơn</th>
                    <th class="text-white" colspan="1">
                        Thu Khách</th>
                    <th class="text-white" colspan="1">
                        Lợi nhận</th>
                    <th class="text-white" colspan="1">
                        Trạng thái</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($shipments as $key => $shipment)
                    @php
                        $data = [
                            'created_at' => formatFullDate($shipment['created_at']),
                            'code' => $shipment['shipment_code'],
                            'branch' => $shipment['branch']['branch_name'],
                            'service' => $shipment['service']['service_name'],
                            'reciver' => $shipment['receiver_contact_name'],
                            'count_pg' => !empty($shipment['packages']) ? collect($shipment['packages'])->count() : 0,
                            'charge_w' => !empty($shipment['packages'])
                                ? collect($shipment['packages'])->sum('package_charged_weight')
                                : 0,
                            'total' =>
                                $shipment['shipment_amount_original'] + $shipment['shipment_amount_operating_costs'],
                            'shipment_amount_surcharge' => $shipment['shipment_amount_surcharge'],
                            'shipment_domestic_charges' => $shipment['shipment_domestic_charges'],
                            'shipment_collection_fee' => $shipment['shipment_collection_fee'],
                            'shipment_amount_original' => $shipment['shipment_amount_original'],
                            'shipment_amount_insurance' => $shipment['shipment_amount_insurance'],
                            'shipment_amount_total_customer' => $shipment['shipment_amount_total_customer'],
                            'shipment_amount_vat' => $shipment['shipment_amount_vat'],
                            'shipment_amount_operating_costs' => $shipment['shipment_amount_operating_costs'],
                            'status' => $shipment['shipment_status_name'],
                            'shipment_amount_profit' => $shipment['shipment_amount_profit'],
                            'payment' =>
                                $shipment['shipment_payment_status'] == 0
                                    ? '<span class="badge badge-danger badge-pill">Chưa thanh toán </span>'
                                    : '<span class="badge badge-success badge-pill">Đã thanh toán </span>',
                        ];
                    @endphp
                    <tr class="odd">
                        <td>
                            <button class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                                onclick="onActionBtnShowClick(this)" data-bs-toggle="collapse"
                                data-bs-target="#pickup_{{ $key }}" aria-expanded="false">
                                <span class="icon">
                                    <i class="fa fa-plus"></i>
                                </span>
                            </button>
                        </td>
                        <td>
                            {{ formatFullDate($shipment['created_at']) }}
                            @if (onCheckPositionAccounts([SETTING_ADMIN_ACCOUNT, SETTING_ACCOUNTANT_ACCOUNT], auth()->user()['position_id']))
                                <span><a
                                        href="{{ route('manages.sale.history', ['shipment_code' => $shipment['shipment_code']]) }}"><i
                                            class="fas fa-user-edit"></i></a></span>
                            @endif
                        </td>
                        <td>
                            @if ($is_fwd)
                                <div class="form-check">
                                    @if (
                                        !isset($shipment['shipment_debit_id']) &&
                                            $shipment['shipment_payment_status'] != 1 &&
                                            !onCheckIsEpacket($shipment['shipment_service_id'], $shipment['service']['promotion_flg']))
                                        <input class="form-check-input" type="checkbox"
                                            {{ in_array($shipment['shipment_id'], $choosed_id) ? 'checked' : '' }}
                                            onclick="onChooseShipment({{ $shipment['shipment_id'] }})"
                                            id="choose_bill_{{ $shipment['shipment_code'] }}">
                                    @endif
                                    <label class="form-check-label fw-bold text-primary"
                                        for="choose_bill_{{ $shipment['shipment_code'] }}">
                                        {{ $shipment['shipment_code'] }}
                                    </label>
                                </div>
                            @else
                                <a
                                    class="fw-bold text-primary"href="{{ route('shipments.detail.show', ['shipment_code' => $shipment['shipment_code']]) }}">
                                    {{ $shipment['shipment_code'] }}
                                </a>
                            @endif
                        </td>
                        <td>{{ $shipment['branch']['branch_name'] }}</td>
                        <td>
                            @include('components.badges-promotion-name', [
                                'service_id' => $shipment['shipment_service_id'],
                                'promotion_flg' => $shipment['service']['promotion_flg'],
                            ])
                            {{ $shipment['service']['service_name'] }}
                        </td>
                        <td class="align-items-center">
                            {{ $shipment['receiver_contact_name'] }}
                        </td>
                        <td>{{ !empty($shipment['packages']) ? collect($shipment['packages'])->count() : 0 }}</td>
                        <td>
                            {{ !empty($shipment['packages']) ? collect($shipment['packages'])->sum('package_charged_weight') : 0 }}
                        </td>
                        <td>
                            {{ formatNumber($shipment['shipment_final_amount']) }}
                        </td>
                        <td>
                            {{ formatNumber($shipment['shipment_amount_total_customer']) }}
                        </td>
                        <td>
                            @if (
                                $shipment['shipment_payment_status'] == 0 ||
                                    !in_array($shipment['shipment_status'], [SHIPMENT_STATUS_IMPORTED, SHIPMENT_STATUS_EXPORED]))
                                <span class="text-danger">
                                    0 <i class="fas fa-exclamation-circle" data-bs-toggle="tooltip"
                                        data-bs-placement="left" title="Chưa đủ điều kiện để tính lợi nhận"></i>
                                </span>
                            @else
                                {{ formatNumber($shipment['shipment_amount_profit']) }}
                            @endif

                        </td>
                        <td>
                            <span
                                class="badge badge-{{ $shipment['shipment_payment_status'] == 0 ? 'danger' : 'success' }} badge-pill">
                                {{ $shipment['shipment_payment_status'] == 0 ? 'Chưa' : 'Đã' }} thanh toán
                            </span>
                        </td>
                    </tr>
                    <tr class="child collapse" id="pickup_{{ $key }}">
                        <td></td>
                        <td colspan="7">
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <strong>Phụ thu:
                                    </strong>
                                    {{ formatNumber($shipment['shipment_amount_surcharge']) }}
                                </div>
                                <div class="col-md-4 mb-3">
                                    <strong>Nội địa:
                                    </strong>
                                    {{ formatNumber($shipment['shipment_domestic_charges']) }}
                                </div>
                                <div class="col-md-4 mb-3">
                                    <strong>Thu hộ:
                                    </strong>
                                    {{ formatNumber($shipment['shipment_collection_fee']) }}
                                </div>
                                <div class="col-md-4 mb-3">
                                    <strong>Bảo hiểm:
                                    </strong>
                                    {{ formatNumber($shipment['shipment_amount_insurance']) }}
                                </div>
                                <div class="col-md-4 mb-3">
                                    <strong>VAT: </strong>
                                    {{ formatNumber($shipment['shipment_amount_vat']) }}
                                </div>
                                <div class="col-md-4 mb-3">
                                    <strong>CPVH: </strong>
                                    {{ formatNumber($shipment['shipment_amount_operating_costs']) }}
                                </div>
                                <div class="col md-4 mb-3">
                                    <strong>Cước gốc:
                                    </strong>
                                    {{ formatNumber($shipment['shipment_amount_original']) }}
                                </div>
                                <div class="col-md-4 mb-3">
                                    <strong>Status:
                                    </strong>
                                    {{ $shipment['shipment_status_name'] }}
                                </div>
                                <div class="col-12">
                                    @if (onCheckPositionAccounts([SETTING_ADMIN_ACCOUNT, SETTING_ACCOUNTANT_ACCOUNT], auth()->user()['position_id']))
                                        <button class="btn btn-icon btn-social btn-info" data-bs-toggle="modal"
                                            data-bs-target="#editTableModal"
                                            onclick="getDetailShipmentCost({{ json_encode($data) }})">
                                            <span class="icon"><i class="fas fa-edit"></i></span>
                                        </button>
                                    @endif
                                </div>
                            </div>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
<div class="d-flex justify-content-center mt-3">
    {{ $shipments->links('components.pagination') }}
</div>
