@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <div class="contactapp-content" style="padding-left: 0px !important">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="dropdown">
                                    <a class="contactapp-title link-dark">
                                        <h1>Liên kết Leader với bảng giá FWD</h1>
                                    </a>

                                </div>

                            </div>
                            <div class="contact-options-wrap">
                                <div class="">
                                    <div class="dropdown ms-3">
                                        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" href="#offcanvasCost"
                                            role="button" aria-controls="offcanvasCost">
                                            <i class="fas fa-plus-circle"></i>
                                            Links FWD to sale
                                        </button>
                                        <a href="{{ route('manages.sale.fwd.add-cost') }}" class="btn btn-primary btn-sm">
                                            <i class="fas fa-dollar-sign"></i>
                                            Áp giá cost cho FWD
                                        </a>
                                    </div>
                                </div>
                                <div class="v-separator d-lg-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                        </header>

                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="contact-list-view">
                                    <div id="datable_1_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                                        <div class="row justify-content-between">
                                            <div class="col mb-3">
                                                <div class="contact-toolbar-left">
                                                </div>
                                            </div>
                                            <div class="col mb-3">
                                                <div class="contact-toolbar-right">
                                                    <div class=""><label><input type="search" id="keywords"
                                                                class="form-control form-control-sm"
                                                                placeholder="Nhấn 'Enter' để tìm kiếm"></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="" id="content"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>

    <div class="modal fade" id="offcanvasCost" tabindex="-1" aria-labelledby="offcanvasCostLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen">
            <div class="modal-content">
                <div class="modal-header bg-primary">
                    <h1 class="modal-title text-white fs-5" id="offcanvasCostLabel">Liên kết Leader với giá FWD</h1>
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal" aria-label="Close"><i
                            class="fas fa-times"></i></button>
                </div>
                <div class="modal-body">
                    <div class="blogapp-content">
                        <div class="blogapp-detail-wrap">
                            <div class="blog-body">
                                <div data-simplebar class="nicescroll-bar">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-xxl-3 col-lg-4 h-100" style="min-height: 500px">
                                                <div class="content-aside">
                                                    <div class="card card-border">
                                                        <div class="card-body">
                                                            <form class="edit-post-form">
                                                                <div
                                                                    class="title title-xs title-wth-divider text-primary text-uppercase mb-3">
                                                                    <span>Hiển thị</span>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="member_cost" class="form-label">Dịch
                                                                        vụ</label>
                                                                    <select id="select_service_cost" class="select2">
                                                                        <option value="">Tất cả</option>
                                                                        @foreach ($services as $key => $service)
                                                                            <option value="{{ $service['service_id'] }}">
                                                                                {{ $service['service_name'] }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                                <div
                                                                    class="title title-xs title-wth-divider text-primary text-uppercase mb-3">
                                                                    <span>Liên kết</span>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="formGroupExampleInput"
                                                                        class="form-label">Chọn Leader</label>
                                                                    <select id="select_leader" class="select2">
                                                                        @foreach ($leaders as $item)
                                                                            <option value="{{ $item['user_id'] }}">
                                                                                {{ $item['user_contact_name'] }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                    <button type="button" id="btn-link-cost"
                                                        onclick="confirmLinkLeader()"
                                                        class="btn btn-primary btn-block mt-3 mb-3">
                                                        Xác nhận
                                                    </button>

                                                </div>
                                            </div>
                                            <div class="col-xxl-9 col-lg-8">
                                                <div class="row">

                                                    <div class="col-12">
                                                        <label for="">Từ khóa</label>
                                                        <div class="input-group mb-3">
                                                            <span class="input-affix-wrapper">
                                                                <input type="text" class="form-control"
                                                                    id="keywords-cost"
                                                                    placeholder="Nhấn 'Enter' để tìm kiếm">
                                                                <span class="input-suffix"><i
                                                                        class="fa fa-search"></i></span>
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div id="content-cost">

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            $(".select2").select2();
            $('.select2').each(function() {
                $(this).select2({
                    dropdownParent: $(this).parent(),
                });
            });
        </script>
        <script src="{{ asset('js/manage/sale/leader-link-cost.js') }}"></script>
    @endpush
@endsection
