@extends('layouts.app')
@section('content')
    <!-- Page Header -->

    <div class="hk-pg-wrapper">
        <div class="px-3">


            <div class="hk-pg-header pg-header-wth-tab pt-7">
                <div class="">
                    <div class="w-100 flex-1">
                        <div class="mb-lg-0 mb-2 me-8">
                            <h1 class="pg-title">Sales Manager</h1>
                            {{-- <p>Create pages using a variety of features that leverage jampack components</p> --}}
                        </div>
                    </div>
                    <div class="my-3">
                        <div class="pg-header-action-wrap">

                        </div>
                    </div>
                </div>

            </div>
            <!-- /Page Header -->
            <!-- Page Body -->
            <div class="hk-pg-body">
                <div class="row">
                    <div class="col-md-6">
                        <div id="line_chart_10"></div>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-hover table-striped mb-0">
                            <thead class="thead-primary fw-bold">
                                <tr>
                                    <th>Tháng</th>
                                    <th>Doanh Thu</th>
                                    <th>Lợi Nhuận</th>
                                    <th>% Rate</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($charts['month'] as $key => $month)
                                    @php
                                        $rate = 0;
                                        $price = $charts['price'][$key];
                                        $profit = $charts['profit'][$key];
                                        $is_down = true;
                                        if ($key > 0 && $profit + $charts['profit'][$key - 1] != 0) {
                                            $check = $profit - $charts['profit'][$key - 1];
                                            $is_down = $check < 0 ? true : false;
                                            $rate = ($check / ($profit + $charts['profit'][$key - 1])) * 100;
                                        } else {
                                            $rate = 0;
                                            $is_down = false;
                                        }
                                    @endphp
                                    <tr>
                                        <td>{{ $month }}</td>
                                        <td>{{ number_format($price) }} VND</td>
                                        <td>{{ number_format($profit) }} VND</td>

                                        <td class=" text-{{ $is_down ? 'danger' : 'success' }}"><i
                                                class="	fas fa-angle-double-{{ $is_down ? 'down' : 'up' }}"></i>
                                            {{ abs(round($rate, 2)) }}%</td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
                <label for="" class="form-label mt-3 h5">Quản lý sale</label>
                <hr class="my-3">
                <div class="row">
                    @foreach ($menus as $key => $menu)
                        @if (in_array(auth()->user()['position_id'], $menu['position_ids']) ||
                                (onCheckPositionAccount(SETTING_ADMIN_ACCOUNT, auth()->user()['position_id']) && !$menu['is_only_sale']) ||
                                ($menu['is_only_sale'] && onCheckPositionAccount(SETTING_SALE_ACCOUNT, auth()->user()['position_id'])))
                            <div class="col-md-4">
                                <div class="card file-compact-card card-border">
                                    <a href="{{ empty($menu['params']) ? route($menu['route']) : route($menu['route'], $menu['params']) }}"
                                        class="btn card-body d-flex justify-content-between align-items-center">
                                        <div class=" media fmapp-info-trigger">
                                            <div class="media-head me-3">
                                                <div class="avatar avatar-icon avatar-sm avatar-soft-primary">
                                                    <span class="initial-wrap"><i class="{{ $menu['icon'] }}"></i></span>
                                                </div>
                                            </div>
                                            <div class="media-body text-start">
                                                <div class="file-name">{{ $menu['name'] }}</div>
                                                <div class="{{ $menu['text-style'] }}">{{ $dashboard[$menu['key']] ?? '' }}
                                                </div>
                                            </div>
                                        </div>
                                        <div class="">
                                            <button class="btn btn-icon btn-soft-primary btn-lg"><span class="icon"><i
                                                        class="fas fa-arrow-right"></i></span></button>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        @endif
                    @endforeach
                    <!-- /Page Body -->
                </div>

                <!-- Page Footer -->
                <!-- / Page Footer -->

            </div>

            @push('scripts')
                <script src="{{ asset('assets/vendors/apexcharts/dist/apexcharts.min.js') }}"></script>
                <script>
                    var charts = @json($charts);
                    var options7 = {
                        series: [{
                            name: 'Doanh thu',
                            data: charts.price
                        }, {
                            name: 'Lợi nhuận',
                            data: charts.profit
                        }],
                        chart: {
                            type: 'bar',
                            height: 350
                        },
                        plotOptions: {
                            bar: {
                                horizontal: false,
                                columnWidth: '55%',
                            },
                        },
                        dataLabels: {
                            enabled: false
                        },
                        stroke: {
                            show: true,
                            width: 2,
                            colors: ['transparent']
                        },
                        xaxis: {
                            categories: charts.month,
                        },
                        yaxis: {
                            title: {
                                text: 'VND'
                            },
                            labels: {
                                formatter: function(value) {
                                    return value.toLocaleString();
                                },
                            },
                        },
                        fill: {
                            opacity: 1
                        },
                        tooltip: {
                            y: {
                                formatter: function(val) {
                                    return val.toLocaleString() + " vnd";
                                }
                            }
                        }
                    };
                    var chart7 = new ApexCharts(document.querySelector("#line_chart_10"), options7);
                    chart7.render();
                </script>
            @endpush
        @endsection
