@extends('layouts.app')
@section('content')
    <div class="hk-pg-wrapper pb-0">
        <!-- Page Body -->
        <div class="hk-pg-body py-0">
            <div class="contactapp-wrap">
                <div class="contactapp-content" style="padding-left: 0px !important">
                    <div class="contactapp-detail-wrap">
                        <header class="contact-header">
                            <div class="d-flex align-items-center">
                                <div class="dropdown">
                                    <a class="contactapp-title link-dark">
                                        <h1>Quản lý sale hỗ trợ FWD</h1>
                                    </a>

                                </div>

                            </div>
                            <div class="contact-options-wrap">
                                <div class="">
                                    <div class="dropdown ms-3">
                                        <button class="btn btn-primary btn-sm" data-bs-toggle="modal"
                                            data-bs-target="#linkFwdModal" role="button" onclick="getDataSelectFwds()">
                                            <i class="fas fa-plus-circle"></i>
                                            Links FWD to sale
                                        </button>
                                        @if (isGetAllData())
                                            <a href="{{ route('manages.sale.fwd.add-cost') }}"
                                                class="btn btn-primary btn-sm">
                                                <i class="fas fa-dollar-sign"></i>
                                                Áp giá cost cho FWD
                                            </a>
                                        @endif
                                        <button id="btn_export_excel" class="btn btn-primary btn-sm">
                                            <i class="fas fa-download"></i>
                                            Export theo tháng
                                        </button>
                                    </div>
                                </div>
                                <div class="v-separator d-lg-block d-none"></div>

                                <a class="btn btn-icon btn-flush-dark btn-rounded 
                                flush-soft-hover hk-navbar-togglable d-sm-inline-block d-none"
                                    href="#" data-bs-toggle="tooltip" data-placement="top" title=""
                                    data-bs-original-title="Collapse">
                                    <span class="icon">
                                        <span class="feather-icon"><i data-feather="chevron-up"></i></span>
                                        <span class="feather-icon d-none"><i data-feather="chevron-down"></i></span>
                                    </span>
                                </a>
                            </div>
                        </header>

                        <div class="contact-body">
                            <div data-simplebar class="nicescroll-bar">
                                <div class="contact-list-view">
                                    <div id="datable_1_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                                        <div class="row justify-content-between">
                                            <div class="col mb-3">
                                                <div class="contact-toolbar-left">
                                                    <input class="form-control form-wth-icon" name="datetimes">
                                                </div>
                                            </div>
                                            <div class="col mb-3">
                                                <div class="contact-toolbar-right">
                                                    <div id="" class=""><label><input type="search"
                                                                id="keywords" class="form-control form-control-sm"
                                                                placeholder="Nhấn 'enter' để tìm kiếm"></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="" id="content"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- /Page Body -->
    </div>

    <!-- Modal -->
    <div class="modal fade" id="linkFwdModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="linkFwdModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="linkFwdModalLabel">Link Sale To FWD</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" style="min-height: 400px" id="content-fwd">
                    @if (!isset($sale_id))
                        <div class="mb-3">
                            <label for="" class="form-label">Lựa chọn sale</label>
                            <select id="select_sale" class="form-control select2">
                                @foreach ($sales as $key => $sale)
                                    <option value="{{ $sale['user_id'] }}">[{{ $sale['user_code'] }}]
                                        {{ $sale['user_contact_name'] }}</option>
                                @endforeach
                            </select>
                        </div>
                    @endif
                    <div class="mb-3">
                        <label for="" class="form-label">Lựa chọn Fwd liên kết</label>
                        <select id="select_fwds" class="form-control select2" multiple="multiple">
                        </select>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
                    <button type="button" class="btn btn-primary" id="btn-modal-create" onclick="onCreateLinks()">Liên
                        kết</button>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/vendors/xlsx/dist/xlsx.full.min.js') }}"></script>
        <script src="{{ asset('assets/vendors/file-saver/dist/FileSaver.min.js') }}"></script>
        <script>
            $(".select2").select2();
            $('.select2').each(function() {
                $(this).select2({
                    dropdownParent: $(this).parent(),
                });
            });
            let pub_sale_id = @json($sale_id);
        </script>
        <script src="{{ asset('js/manage/sale/sale-link-fwd.js') }}"></script>
    @endpush
@endsection
