<div class="row">
    <div class="col-sm-12 table-responsive">
        <table class="table nowrap w-100 mb-5 " role="grid">
            <thead class="thead-primary">
                <tr role="row">
                    <th class="sorting">Sale name</th>
                    <th class="sorting">Doanh Thu</th>
                    <th class="sorting">Lợi Nhuận</th>
                    <th class="">Hạn mức còn lại</th>
                    <th class="">Chưa thanh toán</th>
                    <th class=""></th>
                </tr>
            </thead>
            <tbody>
                @foreach ($sales as $key => $sale)
                    <tr class="odd">
                        <td>
                            @if (isGetAllData())
                                <a
                                    class="fw-bold text-primary"href="{{ route('manages.sale.detail', ['sale_code' => $sale['user_code']]) }}">
                                    {{ $sale['user_contact_name'] }}</a>
                            @else
                                <p class="text-primary">{{ $sale['user_contact_name'] }}</p>
                            @endif
                        </td>
                        <td class="text-success">
                            {{ formatNumber($sale['total_amount_customer']) }}
                        </td>
                        <td class="">
                            {{ formatNumber($sale['total_profit']) }}
                        </td>
                        <td class="text-danger">
                            @if ($sale['position']['limit_amount_flg'] == NO_LIMIT)
                                Không giới hạn
                            @else
                                {{ formatNumber($sale['user_limit_amount_for_sale'] - $sale['user_remaining_limit']) }}đ
                            @endif
                        </td>
                        <td class="text-danger">
                            {{ formatNumber($sale['user_remaining_limit']) }}
                        </td>
                        <td>

                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
<div class="d-flex justify-content-center mt-3">
    {{ $sales->links('components.pagination') }}
</div>
