<div class="mb-3 row">
    @foreach ($sale_kpis as $key => $value)
        <div class="col-lg-12 col-sm-12">
            <div class="card card-refresh">
                <div class="refresh-container">
                    <div class="loader-pendulums"></div>
                </div>
                <div class="card-header card-header-action">
                    <div class="card-title">
                        <a class="h5" href="#">
                            <i class="fas fa-user-tie"></i>
                            {{ $value->kpi_name }}
                        </a>
                        @if ($value->time_kind == NO_TIME_RANGE)
                            <p class="small">Thời hạn: vĩnh viễn</p>
                        @else
                            <p class="small">Thời hạn: {{ $value->time_start }} <i class="fas fa-arrow-alt-circle-right"></i> {{  $value->time_end }}</p>
                        @endif
                    </div>
                    <div class="card-action-wrap">
                        <button class="btn btn-icon btn-flush-primary btn-sm" onclick="showDetailKpi({{ $value->sale_kpi_id }})">
                            <span class="icon"><i class="fas fas fa-edit"></i></span></button>
                        <button class="btn btn-icon btn-flush-danger btn-sm" onclick="onDeleteKpi({{ $value->sale_kpi_id }})">
                            <span class="icon"><i class="fas fa-trash"></i></span></button>

                    </div>
                </div>
                <div id="collapse_{{ $value->sale_team_id }}" class="collapse show">
                    <div class="card-body">
                        <table class="table table-hover table-striped mb-0">
                            <thead>
                                <tr>
                                    <th class="fw-bold">Tên hạn mức</th>
                                    <th class="fw-bold">Hạn mức</th>
                                    <th class="fw-bold">Lương</th>
                                    <th class="fw-bold">Hoa hồng</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($value->range_kpis as $key => $range)
                                    <tr>
                                        <td>{{ $range['range_kpi_name'] }}</td>
                                        <td class=""> {{ number_format($range['profit_start']) . ' -> ' . number_format($range['profit_end']) }}</td>
                                        <td class="fw-bold text-success">
                                            {{ number_format($range['salary']) }} VND
                                        </td>
                                        <td>{{ $range['ratio_commission'] }}%</td>
                                        <td class="">
                                            <div class="hstack flex-wrap gap-3 pb-0">
                                       
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
</div>
<div class="text-center">
    {{ $sale_kpis->links('components.pagination') }}
</div>
