<div class="row">
    <div class="col-lg-12 col-sm-12">
        <table class="table table-hover mb-0">
            <thead class="thead-primary text-white">
                <tr class=" text-white">
                    @if (!$is_company)
                        <th class="fw-bold">Mã</th>
                        <th class="fw-bold">FWD Company name</th>
                    @endif
                    <th class="fw-bold">Dịch Vụ </th>
                    <th class="fw-bold">Cost Leader</th>
                    <th class="fw-bold">Cost Member</th>
                    <th class="fw-bold">Cost Leader Member</th>
                    @if (!$is_company)
                        <th class="fw-bold"></th>
                    @endif
                </tr>
            </thead>
            <tbody>
                @foreach ($fwd_costs as $key => $value)
                    <tr>
                        @if (!$is_company)
                            <td>{{ $value['user_code'] }}</td>
                            <td class="fw-bold">
                                <a href="{{ route('manages.sale.fwd.company', ['company_code' => $value['user_code']]) }}">
                                    {{ $value['user_company_name'] }}
                                </a>
                            </td>
                        @endif
                        <td>{{ $value['service_name'] }}</td>
                        <td>{{ number_format($value['leader_cost']) }} /kg</td>
                        <td>{{ number_format($value['member_cost']) }} /kg</td>
                        <td>{{ number_format($value['leader_member_cost']) }} /kg</td>
                        @if (!$is_company)
                            <td>
                                <button class="btn btn-primary btn-sm"
                                    onclick="openModalUpdate(
                                            {{ $value['fwd_cost_id'] }}, 
                                            '{{ number_format($value['leader_cost']) }}',
                                            '{{ number_format($value['member_cost']) }}',
                                            '{{ number_format($value['leader_member_cost']) }}'
                                        )">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-danger btn-sm"
                                    onclick="onDeleteCost({{ $value['fwd_cost_id'] }})">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        @endif
                    </tr>
                @endforeach

            </tbody>
        </table>
    </div>
    <div class="d-flex justify-content-center mt-3">
        {{ $fwd_costs->links('components.pagination') }}
    </div>
</div>
