<div class="row">
    <table class="table">
        <thead>
            <tr>
                <th class="fw-bold">Sale name</th>
                <th class="fw-bold">Company</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($datas as $key => $data)
                @php
                    $companys1 = getCompanyLinkSaleWithWeight($data['user_id'], $filters);
                @endphp
                <tr class="{{ count($companys1) ? '' : 'd-none' }}">
                    <td>
                        @if (isGetAllData())
                            <a class="text-dark h5"
                                href="{{ route('manages.sale.detail', ['sale_code' => $data['user_code']]) }}">
                                <i class="fas fa-user-tie"></i>
                                {{ $data['user_contact_name'] }}
                            </a>
                        @else
                            <h5 class="text-dark"><i class="fas fa-user-tie"></i>{{ $data['user_contact_name'] }}</h5>
                        @endif
                    </td>
                    <td>
                        <div class="">
                            <table class="table table-striped">
                                <thead class="thead-primary">
                                    <tr>
                                        <th scope="col">Company name</th>
                                        <th scope="col">weight</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($companys1 as $company1)
                                        <tr>
                                            <td>
                                                <a
                                                    href="{{ route('manages.sale.fwd.company', ['company_code' => $company1['user_code']]) }}">
                                                    {{ $company1['user_company_name'] }}
                                                </a>
                                            </td>
                                            <td>
                                                {{ $company1['total_weight'] ?? 0 }}
                                            </td>
                                            <td>
                                                <button class="btn btn-danger btn-sm"
                                                    onclick="onDeleteLink({{ $company1['sale_link_fwd_id'] }})">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                    @if (!empty($data['members']))
                                        @foreach ($data['members'] as $member)
                                            <tr>
                                                <td colspan="3">
                                                    <p class="fw-bold text-dark"><i
                                                            class="fas fa-users"></i>{{ $member['user_contact_name'] }}
                                                    </p>
                                                </td>
                                            </tr>
                                            @foreach (getCompanyLinkSaleWithWeight($member['user_id'], $filters) as $company2)
                                                <tr>
                                                    <td> <span class="ms-3"><i class="fas fa-caret-right"></i></span>
                                                        <a
                                                            href="{{ route('manages.sale.fwd.company', ['company_code' => $company2['user_code']]) }}">
                                                            {{ $company2['user_company_name'] }}
                                                        </a>
                                                    </td>
                                                    <td>
                                                        {{ $company2['total_weight'] ?? 0 }}
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-danger btn-sm"
                                                            onclick="onDeleteLink({{ $company2['sale_link_fwd_id'] }})">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
