<div class="row">
    <table class="table table-hover table-striped mb-0">
        <thead>
            <tr>
                <th class="fw-bold">FWD Company</th>
                <th class="fw-bold">Sale</th>
                <th class="fw-bold">Total C.W</th>
                <th class="fw-bold"></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($companies as $key => $company)
                <tr>
                    <td class="fw-bold">
                        <a class="text-dark" href="{{ route('manages.sale.fwd.company', ['company_code' => $company['company_code']]) }}">
                            {{ $company['company_name'] }}
                        </a>
                    </td>
                    <td>
                        @if (isGetAllData())
                            <a class="text-dark"
                                href="{{ route('manages.sale.detail', ['sale_code' => $company['sale_code']]) }}">
                                {{ $company['sale_name'] }}
                            </a>
                        @else
                            <p class="text-dark">
                                {{ $company['sale_name'] }}
                            </p>
                        @endif
                        <br>
                        <small>{{ isset($company['leader_name']) ? 'Leader: ' . $company['leader_name'] : 'Sale chưa có nhóm' }}</small>
                    </td>
                    <td>{{ isset($company['fw_weight']) ? $company['fw_weight'] : 0 }} kg</td>
                    <td>
                        @if (!isset($sale_id))
                            <button class="btn btn-danger btn-sm"
                                onclick="onDeleteLink({{ $company['sale_link_fwd_id'] }})">
                                <i class="fas fa-trash"></i>
                            </button>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="text-center">
    {{ $companies->links('components.pagination') }}
</div>
