<div class="row">
    @foreach ($sales as $key => $sale)
        <div class="col-lg-12 col-sm-12">
            <div class="card card-refresh">
                <div class="refresh-container">
                    <div class="loader-pendulums"></div>
                </div>
                <div class="card-header card-header-action">
                    <div class="card-header card-header-wth-text card-header-action">
                        <div>
                            @if (isGetAllData())
                                <a  class="text-dark h5"
                                    href="{{ route('manages.sale.detail', ['sale_code' => $sale['user_code']]) }}">
                                    <i class="fas fa-user-tie"></i>
                                    {{ $sale['user_contact_name'] }}
                                </a>
                            @else
                                <h5 class="text-dark">{{ $sale['user_contact_name'] }}</h5>
                            @endif
                            @if (empty($sale['leader']))
                                <p>Sale chưa tham gia nhóm</p>
                            @else
                                <p class="text-dark">Leader: {{ $sale['leader']['user_contact_name'] }}</p>
                            @endif
                        </div>
                        <div class="card-action-wrap">
                            <a class="btn btn-xs btn-icon btn-rounded btn-flush-dark flush-soft-hover"
                                data-bs-toggle="collapse" href="#collapse_{{ $sale['sale_id'] }}"
                                aria-expanded="true"><span class="icon"><span class="feather-icon"><i
                                            data-feather="chevron-down"></i></span></span></a>
                        </div>

                    </div>
                </div>
                <div id="collapse_{{ $sale['sale_id'] }}" class="collapse show">
                    <div class="card-body">
                        <table class="table table-hover table-striped mb-0">
                            <thead>
                                <tr>
                                    <th class="fw-bold">FWD Company</th>
                                    <th class="fw-bold">Total C.W</th>
                                    <th class="fw-bold"></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($sale['companies'] as $key => $company)
                                    <tr>
                                        <td class="fw-bold">
                                            <a
                                                href="{{ route('manages.sale.fwd.company', ['company_code' => $company['user_code']]) }}">
                                                {{ $company['user_company_name'] }}
                                            </a>
                                        </td>
                                        <td>{{ isset($company['fw_weight']) ? $company['fw_weight'] : 0 }} kg</td>
                                        <td>
                                            <button class="btn btn-danger btn-sm"
                                                onclick="onDeleteLink({{ $company['sale_link_fwd_id'] }})">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
</div>
<div class="text-center">
    {{ $sales->links('components.pagination') }}
</div>
