<div class="row">
    @foreach ($fwd_costs as $key => $value)
        <div class="col-lg-12 col-sm-12">
            <div class="card card-refresh">
                <div class="refresh-container">
                    <div class="loader-pendulums"></div>
                </div>
                <div class="card-header card-header-action">
                    <div class="card-title">
                        @if (isGetAllData())
                            <a class="h5"
                                href="{{ route('manages.sale.detail', ['sale_code' => $value['sale_code']]) }}">
                                <i class="fas fa-user-tie"></i>
                                {{ $value['user_contact_name'] }}
                            </a>
                        @else
                            <h5 class="text-primary">{{ $value['user_contact_name'] }}</h5>
                        @endif
                    </div>
                    <div class="card-action-wrap">
                        <a class="btn btn-xs btn-icon btn-rounded btn-flush-dark flush-soft-hover"
                            data-bs-toggle="collapse" href="#collapse_{{ $value['leader_id'] }}"
                            aria-expanded="true"><span class="icon"><span class="feather-icon"><i
                                        data-feather="chevron-down"></i></span></span></a>
                    </div>
                    <small class="mx-3">Mã: {{ $value['user_code'] }}</small>
                </div>
                <div id="collapse_{{ $value['leader_id'] }}" class="collapse show">
                    <div class="card-body">
                        <table class="datable table table-hover table-striped mb-0">
                            <thead>
                                <tr>
                                    <th class="fw-bold">Mã TK</th>
                                    <th class="fw-bold">FWD Company</th>
                                    <th class="fw-bold">service</th>
                                    <th class="fw-bold">leader</th>
                                    <th class="fw-bold">member</th>
                                    <th class="fw-bold">leader to member</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($value['fwdCosts'] as $index => $item)
                                    <tr>
                                        <td class="fw-bold">{{ $item['user_code'] }}</td>
                                        <td class="fw-bold">
                                            <a
                                                href="{{ route('manages.sale.fwd.company', ['company_code' => $item['user_code']]) }}">
                                                {{ $item['user_company_name'] }}
                                            </a>
                                        </td>
                                        <td>{{ $item['service_name'] }}</td>
                                        <td>{{ number_format($item['leader_cost']) }} /kg</td>
                                        <td>{{ number_format($item['member_cost']) }} /kg</td>
                                        <td>{{ number_format($item['leader_member_cost']) }} /kg</td>
                                        <td>
                                            <button class="btn btn-danger btn-sm"
                                                onclick="onRemoveLink({{ $item['fwd_cost_id'] }})">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
</div>
<div class="text-center">
    {{ $fwd_costs->links('components.pagination') }}
</div>
