<div class="table-responsive">
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col">#</th>
                <th scope="col">Tài khoản</th>
                <th scope="col">Mã người dùng</th>
                <th scope="col">Tên công ty</th>
                <th scope="col">Số điện thoại</th>
                <th scope="col">Chức vụ</th>
                <th scope="col"></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($wait_users as $user)
                <tr>
                    <th scope="row">{{ $loop->iteration }}</th>
                    <td>{{ $user['user_name'] }}</td>
                    <td>{{ $user['user_code'] }}</td>
                    <td>{{ $user['user_contact_name'] }}</td>
                    <td>{{ $user['user_phone'] }}</td>
                    <td>{{ isset($user['position']['position_name']) ? $user['position']['position_name'] : '' }}</td>
                    <td>{{ formatNumber($user['user_limit_amount_for_sale']) }}đ</td>
                    <td>{{ formatNumber($user['user_remaining_limit']) }}đ</td>
                    <td>
                        <div class="d-flex align-items-center">
                            @if (onGetPositionIdFWDAccount() == $user['position_id'])
                                <x-buttons.btn-link-edit click="onEditFWDUser({{ $user['user_id'] }})"/>
                            @else
                                <x-buttons.btn-link-edit click="onEditUser({{ $user['user_id'] }})"/>
                            @endif
                            <a onclick="onLockUser({{ $user['user_id'] }}, {{ $user['active_flg'] }})"
                            class="btn"><i class="far fa-check-circle"></i></a>
                            <a type="button" onclick="onDeleteUser({{ $user['user_id'] }})"
                            class="btn"><i class="fas fa-trash"></i></a>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $wait_users->links('components.pagination') }}
</div>
