<div class="table-responsive" style="min-height: 560px">
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col">#</th>
                <th scope="col">Tài khoản</th>
                <th scope="col">Mã người dùng</th>
                <th scope="col">Tên nhân viên</th>
                <th scope="col">Số điện thoại</th>
                <th scope="col">Chức vụ</th>
                <th scope="col">Hạn mức nợ</th>
                <th scope="col">Số tiền nợ</th>
                <th scope="col"></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($users as $user)
                <tr>
                    <th scope="row">{{ $loop->iteration }}</th>
                    <td>{{ $user['user_name'] }}
                        @if ($user['active_flg'] == INACTIVE)
                            <i class="ms-1 fas fa-lock"></i>
                        @endif
                        @if ($user['is_export'] == INACTIVE)
                            <i data-bs-toggle="tooltip" data-bs-placement="right"
                                title="Tài khoản đang bị khóa xuất đơn hàng" class="fas fa-plane-arrival"></i>
                        @endif
                    </td>
                    <td>{{ $user['user_code'] }}</td>
                    <td>{{ $user['user_contact_name'] }}</td>
                    <td>{{ $user['user_phone'] }}</td>
                    <td>{{ isset($user['position']['position_name']) ? $user['position']['position_name'] : '' }}</td>
                    <td>
                        @if ($user['position']['limit_amount_flg'] == NO_LIMIT)
                            Không giới hạn
                        @else
                            {{ formatNumber($user['user_limit_amount_for_sale']) }}đ
                        @endif
                    </td>
                    <td>{{ formatNumber($user['user_remaining_limit']) }}đ</td>
                    <td>
                        @if (isGetAllData() && !onCheckDocumentAccount())
                            <div class="btn-group dropdown">
                                <button type="button" class="btn btn-icon btn-flush-secondary"
                                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <span class="icon"><i class="fas fa-cog"></i></span>
                                </button>
                                <div class="dropdown-menu dropdown-bordered">
                                    <button class="dropdown-item" onclick="onEditUser({{ $user['user_id'] }})"><i
                                            class="dropdown-icon fas fa-pen"></i><span>Cập nhật</span></button>
                                    <div class="dropdown-divider"></div>
                                    <button class="dropdown-item"
                                        onclick="onLockUser({{ $user['user_id'] }}, {{ $user['active_flg'] }})"><i
                                            class="dropdown-icon fas {{ $user['active_flg'] == ACTIVE ? 'fa-lock' : 'fa-unlock' }}">
                                        </i><span>{{ $user['active_flg'] == ACTIVE ? 'Khóa' : 'Mở' }} tài
                                            khoản</span></button>
                                    <div class="dropdown-divider"></div>

                                    <button class="dropdown-item"
                                        onclick="onLockExport({{ $user['user_id'] }}, {{ $user['is_export'] }})">
                                        <i
                                            class="dropdown-icon fas {{ $user['is_export'] == ACTIVE ? 'fa-plane-arrival' : 'fa-plane-departure' }}">
                                        </i><span>{{ $user['is_export'] == ACTIVE ? 'Khóa' : 'Mở' }}
                                            Export</span></button>
                                    <div class="dropdown-divider"></div>

                                    @if (onCheckAdminAccount())
                                        <button class="dropdown-item"
                                            onclick="onDeleteUserById({{ $user['user_id'] }})"><i
                                                class="dropdown-icon fas fa-trash"></i><span>Xóa tài
                                                khoản</span></button>
                                        <div class="dropdown-divider"></div>
                                    @endif
                                    <button class="dropdown-item" onclick="onRefreshWallet({{ $user['user_id'] }})"><i
                                            class="dropdown-icon fas fa-wallet"></i><span>Reset ví
                                            tiền</span></button>
                                    <div class="dropdown-divider"></div>
                                    <button class="dropdown-item"
                                        onclick="onDeductWallet({{ $user['user_id'] }}, {{ $user['wallet']['amount'] ?? null }} )">
                                        <i class="dropdown-icon fas fa-wallet text-danger"></i>
                                        <span>Trừ tiền trong ví</span>
                                    </button>
                                    <div class="dropdown-divider"></div>
                                    <button class="dropdown-item"
                                        onclick="onOpenResetDebitModal( {{ $user['user_id'] }}, '{{ $user['user_contact_name'] }}' )">
                                        <i class="dropdown-icon fas fa-wallet text-warning"></i>
                                        <span>Reset công nợ</span>
                                    </button>
                                    <div class="dropdown-divider"></div>
                                    <button class="dropdown-item"
                                        onclick="onDeductDebit( {{ $user['user_id'] }}, {{ $user['user_remaining_limit'] }} )">
                                        <i class="dropdown-icon fas fa-wallet text-warning"></i>
                                        <span>Trừ công nợ</span>
                                    </button>
                                </div>
                            </div>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

<div class="d-flex justify-content-center mt-5">
    {{ $users->links('components.pagination') }}
</div>
