<style>
    .form-check-input:checked {
        background-color: #00ff2f !important;
        border-color: #00ff2f !important;
    }
</style>
@php
    $name_branchs = getNameBranchsById();
@endphp
<div class="row gx-3">

    @foreach ($price_list as $item => $price)
        <div class="col-sm-4">
            <div class="card">
                <div class="card-header bg-primary">
                    <label class="h6 text-white"
                        for="selected-price-list-{{ $price['price_list_id'] }}">
                        {{ $price['price_list_title'] }}
                        ({{ $price['price_list_start_date'] }} - {{ $price['price_list_end_date'] }})
                    </label>
                    <div class="d-flex">
                        <input class="form-check-input text-info" type="radio" name="user_price_list_main_type"
                            value="{{ $price['price_list_id'] }}" id="selected-price-list-{{ $price['price_list_id'] }}"
                            onclick="onShowDisplayService({{ $price['price_list_id'] }})"
                            {{ isset($user_price_list_main_type) && $user_price_list_main_type == $price['price_list_id'] ? 'checked' : '' }}>
                    </div>
                </div>
                <div class="card-body display-select {{ isset($user_child_price_list[0]) && $user_child_price_list[0]['price_list_id'] == $price['price_list_id'] ? '' : 'd-none' }}" id="display-select-{{ $price['price_list_id'] }}">
                    @php
                        $child_price_by_branch = collect($price['child_price_list'])
                            ->groupBy('branch_id')
                            ->all();
                    @endphp
                    @foreach ($child_price_by_branch as $key => $child_price)
                        <div class="p-3 mb-3 border rounded">
                            <label for="">Chi nhánh: {{ isset($name_branchs[$key]) ? $name_branchs[$key] : 'Mã chi nhánh: '.$key}}</label>
                            @foreach ($child_price as $index => $child_item)
                                <div class="form-check">
                                    <input class="form-check-input" type="radio"
                                        name="child_price_list_{{ $key }}"
                                        value="{{ $child_item['child_price_list_id'] }}"
                                        id="child_price_list_{{ $child_item['child_price_list_id'] }}"
                                        {{ !empty($user_child_price_list) && checkSelectChildPriceService($user_child_price_list, $child_item['child_price_list_id']) ? 'checked' : '' }}>
                                    <label class="form-check-label"
                                        for="child_price_list_{{ $child_item['child_price_list_id'] }}">
                                        {{ $child_item['child_price_list_title'] }}
                                    </label>
                                </div>
                            @endforeach
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endforeach
    <small id="error_user_price_list_main_type" class="text-danger"></small>
</div>
