<div class="blogapp-content">
    <div class="blogapp-detail-wrap">
        <div class="blog-body">
            <div data-simplebar class="nicescroll-bar">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="row">
                                <div class="col-xxl-6 col-lg-6">
                                    <div class="form-group">
                                        <label class="form-label">Chức vụ</label>
                                        <select class="form-select" name="users_position_id">
                                            <option selected value="">Tất cả</option>
                                            @foreach ($positions as $position)
                                                <option value="{{ $position['position_id'] }}">
                                                    {{ $position['position_name'] }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xxl-6 col-lg-6">
                                    <div class="form-group">
                                        <label class="form-label">Chi nhánh</label>
                                        <select class="form-select" name="users_branch_id">
                                            <option selected value="">Tất cả</option>
                                            @foreach ($branchs as $branch)
                                                <option value="{{ $branch['branch_id'] }}">
                                                    {{ $branch['branch_name'] }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xxl-6 col-lg-6">
                                    <div class="form-group">
                                        <label class="form-label">Trạng thái</label>
                                        <select class="form-select" name="users_active_flg">
                                            <option selected value="">Tất cả</option>
                                            <option value="{{ ACTIVE }}">Chưa khóa</option>
                                            <option value="{{ INACTIVE }}">Đã khóa</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xxl-6 col-lg-6">
                                    <div class="form-group">
                                        <label class="form-label">Tìm kiếm</label>
                                        <input type="text" name="users_keywords" class="form-control"
                                            placeholder="Nhập nội dung bạn muốn tìm kiếm">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <x-spinner id="loading_show_table_content" />
                            <div class="text-start mb-3">
                                <button type="button" onclick="onLoadPageCreateUser()" class="btn btn-primary">
                                    <strong>+</strong>
                                    Tạo mới người dùng
                                </button>
                            </div>
                            <div id="show_table_content">
                                @include('manage.admin.system.user.users-pagination')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="deductWalletModal" tabindex="-1" role="dialog" aria-labelledby="deductWalletModalLabel"
    aria-hidden="true" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <h5 class="modal-title text-white" id="deductWalletModalLabel">Trừ tiền tài khoản</h5>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-12 mb-3">
                        <p><span>Số dư hiện tại:</span> <span class="text-danger fw-bold" id="currentAmount"></span>đ
                        </p>
                    </div>
                    <div class="col-12 mb-3">
                        <p>Số tiền</p>
                        <input type="number" id="deductAmount" placeholder="Nhập số tiền muốn trừ" min="1"
                            class="form-control">
                    </div>
                    <div class="col-12">
                        <p>Ghi chú</p>
                        <textarea type="text" id="deductNote" class="form-control" placeholder="Nhập ghi chú"></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeDeductWalletModal()">Hủy</button>
                <button type="button" class="btn btn-primary" id="deductWalletConfirm">Xác nhận</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="deductDebitModal" tabindex="-1" role="dialog" aria-labelledby="deductDebitModalLabel"
    aria-hidden="true" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <h5 class="modal-title text-white" id="deductDebitModalLabel">Trừ công nợ</h5>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-12 mb-3">
                        <p><span>Công nợ hiện tại:</span> <span class="text-danger fw-bold" id="currentDebit"></span>đ
                        </p>
                    </div>
                    <div class="col-12 mb-3">
                        <p>Số tiền</p>
                        <input type="number" id="deductDebitAmount" placeholder="Nhập số tiền muốn trừ" min="1"
                            class="form-control">
                    </div>
                    <div class="col-12">
                        <p>Ghi chú</p>
                        <textarea type="text" id="deductDebitNote" class="form-control" placeholder="Nhập ghi chú"></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeDeductDebitModal()">Hủy</button>
                <button type="button" class="btn btn-primary" id="deductDebitConfirm">Xác nhận</button>
            </div>
        </div>
    </div>
</div>
