<div class="blogapp-content">
    <div class="blogapp-detail-wrap">
        <div class="blog-body">
            <div data-simplebar class="nicescroll-bar">
                <div class="container-fluid">
                    <form>
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex flex-row">
                                <a class="btn btn-icon btn-flush-dark btn-rounded flush-soft-hover mb-0"
                                    href="javascript:void(0);" onclick="onLoadPageUsers()">
                                    <span class="icon">
                                        <span class="feather-icon fs-2">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                class="feather feather-chevron-left">
                                                <polyline points="15 18 9 12 15 6"></polyline>
                                            </svg>
                                        </span>
                                    </span>
                                </a>
                                <a class="mt-2" href="javascript:void(0);" onclick="onLoadPageUsers()">
                                    <h5>Quay lại</h5>
                                </a>
                            </div>
                            <button type="submit" id="on_save_edit_user" class="btn btn-primary mb-0"
                                onclick="onSaveEditUser('{{ $user['user_id'] }}')">
                                Chỉnh sửa tài khoản
                            </button>
                        </div>
                        <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                            <span>Thông tin tài khoản</span>
                        </div>
                        <div class="row gx-3">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="form-label">Tài khoản *</label>
                                    <input class="form-control" type="text" name="user_name"
                                        placeholder="Nhập tài khoản" value="{{ $user['user_name'] }}">
                                    <small id="error_user_name" class="text-danger"></small>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    @if (onCheckPositionAccount(SETTING_ADMIN_ACCOUNT, $user['position_id']))
                                        <label class="form-label">Mật khẩu
                                            <small>(Lưu ý: khi bạn nhập mật khẩu sẽ được thay
                                                đổi)</small></label>
                                    @else
                                        <label class="form-label">Mật khẩu:
                                            {{ $user['password_show'] ?? 'Hãy cập nhật lại mật khẩu để có thể coi' }}
                                            <small>(Lưu ý: khi bạn nhập mật khẩu sẽ được thay
                                                đổi)</small></label>
                                    @endif

                                    <div class="input-group password-check">
                                        <span class="input-affix-wrapper affix-wth-text">
                                            <input name="password" class="form-control" placeholder="Nhập mật khẩu"
                                                type="password">
                                            <a href="javascript:void(0);"
                                                class="input-suffix text-primary text-uppercase fs-8 fw-medium">
                                                <span>Show</span>
                                                <span class="d-none">Hide</span>
                                            </a>
                                        </span>
                                    </div>
                                    <small id="error_password" class="text-danger"></small>
                                </div>
                            </div>
                        </div>
                        <div class="row gx-3">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="form-label">Chức vụ *</label>
                                    <select class="form-select" name="position_id">
                                        <option value="">Chọn một chức vụ</option>
                                        @foreach ($positions as $position)
                                            <option value="{{ $position['position_id'] }}"
                                                {{ $user['position_id'] == $position['position_id'] ? 'selected' : '' }}>
                                                {{ $position['position_name'] }}</option>
                                        @endforeach
                                    </select>
                                    <small id="error_position_id" class="text-danger"></small>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="form-label">Chi nhánh *</label>
                                    <select class="form-select" name="branch_id">
                                        <option value="">Chọn một chi nhánh</option>
                                        @foreach ($branchs as $branch)
                                            <option value="{{ $branch['branch_id'] }}"
                                                {{ $user['branch_id'] == $branch['branch_id'] ? 'selected' : '' }}>
                                                {{ $branch['branch_name'] }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <small id="error_branch_id" class="text-danger"></small>
                                </div>
                            </div>
                        </div>
                        @if (isset($user['position']) && $user['position']['limit_amount_flg'] == LIMITED)
                            <div id="form_user_limit_amount_for_sale" class="row gx-3">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form-label">Số tiền hạn mức</label>
                                        <input name="user_limit_amount_for_sale" class="form-control" type="text"
                                            placeholder="Nhập số tiền hạn mức cho"
                                            value="{{ formatNumber($user['user_limit_amount_for_sale']) }}">
                                        <small id="error_user_limit_amount_for_sale" class="text-danger"></small>
                                    </div>
                                </div>
                            </div>
                        @endif
                        <div class="row gx-3">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="form-label">Tên Liên Hệ *</label>
                                    <input class="form-control" type="text" name="user_contact_name"
                                        placeholder="Nhập tên liên hệ" value="{{ $user['user_contact_name'] }}">
                                    <small id="error_user_contact_name" class="text-danger"></small>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="form-label">Số điện thoại *</label>
                                    <input class="form-control" type="number" name="user_phone"
                                        placeholder="Nhập số điện thoại" value="{{ $user['user_phone'] }}">
                                    <small id="error_user_phone" class="text-danger"></small>
                                </div>
                            </div>
                        </div>
                        <div class="row gx-3">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="form-label">Địa chỉ *</label>
                                    <input name="user_address" class="form-control" type="text"
                                        placeholder="Nhập địa chỉ" value="{{ $user['user_address'] }}">
                                    <small id="error_user_address" class="text-danger"></small>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="form-label">Chọn bảng giá</label>
                                    <select class="form-select" name="user_price_list_main_type">
                                        @foreach ($price_list_types as $key_price_list_type => $price_list_type)
                                            <option value="{{ $key_price_list_type }}"
                                                {{ $key_price_list_type == $user['user_price_list_main_type'] ? 'selected' : '' }}>
                                                {{ $price_list_type }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <small id="error_user_price_list_main_type" class="text-danger"></small>
                                </div>
                            </div>
                        </div>
                        {{-- <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                            <span>Bảng giá dịch vụ sử dụng</span>
                        </div>
                        @include('manage.admin.system.user.template.service', [
                            'price_list' => $price_list,
                            'user_price_list_main_type' => isset($user['user_price_list_main_type'])
                                ? $user['user_price_list_main_type']
                                : null,
                            'user_child_price_list' => $user_child_price_list,
                        ]) --}}
                        {{-- <div class="row gx-3">
                            @foreach ($price_list as $key => $price)
                                <div class="col-sm-4">
                                    <div class="btn-group mb-3 w-100">
                                        <button type="button" class="btn border border-primary">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="user_price_list_main_type" 
                                                    value="{{ $price['price_list_id'] }}" id="selected-price-list-{{ $key }}"
                                                    {{ $price['price_list_id'] == $user['user_price_list_main_type'] ? 'checked' : '' }}>
                                                <label class="form-check-label" for="selected-price-list-{{ $key }}">
                                                    {{ $price['price_list_title'] }}
                                                </label>
                                            </div>
                                        </button>
                                        <button type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown" aria-expanded="false">
                                            <span class="visually-hidden">Toggle Dropdown</span>
                                        </button>
                                        <ul class="dropdown-menu">
                                            @foreach ($price['child_price_list'] as $index => $child_price_list)
                                                <li><a class="dropdown-item" href="javascript:void(0)">
                                                    {{ $child_price_list['child_price_list_title'] }}
                                                </a></li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endforeach
                            <small id="error_user_price_list_main_type" class="text-danger"></small>
                        </div> --}}
                        <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                            <span>Chữ ký</span>
                        </div>
                        <div class="row gx-3 mb-4">
                            <div class="col-12">
                                <div class="form-check mb-3">
                                    <input type="checkbox" name="agree_user_signature" class="form-check-input"
                                        id="agree_user_signature">
                                    <label class="form-check-label" for="agree_user_signature">
                                        Xác nhận lưu và sử dụng chữ ký này!
                                    </label>
                                    @if (isset($user['user_signature']))
                                        <a href="{{ url($user['user_signature']) }}" target="_blank"
                                            class="btn btn-sm btn-primary">
                                            Xem chữ ký đã lưu
                                        </a>
                                    @endif
                                </div>
                                <div id="bcPaint"></div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<link rel="stylesheet" href="{{ asset('assets/vendors/signaturepad/bcPaint.css') }}">
<link rel="stylesheet" href="{{ asset('assets/vendors/signaturepad/demo-page.css') }}">
<link rel="stylesheet" href="{{ asset('assets/vendors/signaturepad/bcPaint.mobile.css') }}">
<script src="{{ asset('assets/vendors/signaturepad/bcPaint.js') }}"></script>
<script type="text/javascript">
    $('#bcPaint').bcPaint();
</script>
