<div class="table-responsive">
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col">ID</th>
                <th scope="col">Post Code</th>
                <th scope="col">State Name</th>
                <th scope="col">State Code</th>
                <th scope="col">Quốc gia</th>
                <th scope="col">Trạng thái</th>
                <th scope="col"></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($states as $state)
                <tr>
                    <th scope="row">{{ $state['state_id'] }}</th>
                    <td>{{ $state['state_post_code'] }}</td>
                    <td>{{ $state['state_name'] }}</td>
                    <td>{{ $state['state_code'] }}</td>
                    <td>{{ isset($state['country']) ? $state['country']['country_name'] : '' }}</td>
                    <td>{{ $state['active_name'] }}</td>
                    <td>
                        <div class="d-flex align-items-center">
                            <x-buttons.btn-link-edit click="onEditState({{ $state['state_id'] }})"/>
                            <x-buttons.btn-link-delete click="onDeleteState({{ $state['state_id'] }})"/>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $states->links('components.pagination') }}
</div>
