<div class="blogapp-content">
    <div class="blogapp-detail-wrap">
        <div class="blog-body">
            <div data-simplebar class="nicescroll-bar">
                <div class="container-fluid" style="min-height: 500px">
                    <div class="text-end">
                        <button type="button" id="save_system_settings" onclick="saveSystemSettings()"
                            class="btn btn-warning mb-3">
                            <span>Lưu lại những thay đổi</span>
                        </button>
                    </div>
                    <div class="row">
                        @foreach ($system_settings as $key_setting => $system_setting)
                            @if (!in_array($system_setting['kind'], [SETTING_KEY_VNP]))    
                                <div class="col-xxl-3 col-lg-4">
                                    <div class="card">
                                        <div class="card-header fw-bold">
                                            {{ $system_setting['title'] }}
                                        </div>
                                        <div class="card-body">
                                            @if (isset($system_setting['data']))
                                                @if (in_array($system_setting['kind'], [SETTING_ALL_ACCOUNT]))
                                                    @foreach ($system_setting['data'] as $key_data => $data)
                                                        <div class="form-check form-switch mb-3">
                                                            <input type="checkbox" class="form-check-input"
                                                                name="{{ $data['name'] }}"
                                                                id="form_switch_{{ $key_setting }}_{{ $key_data }}"
                                                                {{ $data['active_flg'] == ACTIVE ? 'checked' : '' }}>
                                                            <label class="form-check-label"
                                                                for="form_switch_{{ $key_setting }}_{{ $key_data }}">
                                                                {{ $data['title'] }}
                                                            </label>
                                                        </div>
                                                    @endforeach
                                                @elseif (in_array($system_setting['kind'], [SETTING_ADMIN_ACCOUNT, SETTING_ACCOUNTANT_ACCOUNT, SETTING_DOCUMENT_ACCOUNT, SETTING_SALE_ACCOUNT, SETTING_FWD_ACCOUNT, SETTING_SHIPPER_ACCOUNT, SETTING_DRIVER_ACCOUNT, SETTING_OPS_LEADER_ACCOUNT]))
                                                    <div class="form-group">
                                                        <select class="form-select select2"
                                                            name="{{ $system_setting['name'] }}"
                                                            id="{{ $system_setting['name'] }}">
                                                            <option value="">Chọn một chức vụ</option>
                                                            @foreach ($system_setting['data'] as $key_data => $data)
                                                                <option value="{{ $data['position_id'] }}"
                                                                    {{ $data['position_id'] == $system_setting['position_id'] ? 'selected' : '' }}>
                                                                    {{ $data['position_name'] }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        <small id="error_{{ $system_setting['name'] }}"
                                                            class="text-danger"></small>
                                                    </div>
                                                @elseif (in_array($system_setting['kind'], [SETTING_ACCOUNT_EDIT_ORDER_PICKUP, SETTING_ACCOUNT_UPDATE_NOTIFICATIONS, SETTING_ACCOUNT_VIEW_AND_UPDATE_SHIPMENT_OPERATING_COST, SETTING_ACCOUNT_SCAN, SETTING_ACCOUNT_TICKET, SETTING_ACCOUNT_DEBITS, SETTING_PRINT_BILL_TYPE]))
                                                    
                                                    <div class="form-group">
                                                        <select class="form-select select2 select2-multiple" multiple="multiple"
                                                            name="{{ $system_setting['name'] }}"
                                                            id="{{ $system_setting['name'] }}">
                                                            @if ($system_setting['kind'] == SETTING_ACCOUNT_DEBITS)
                                                                @dump($system_setting['data'])
                                                            @endif
                                                            @foreach ($system_setting['data'] as $key_data => $data)
                                                                <option value="{{ $data['position_id'] }}"
                                                                    {{ in_array($data['position_id'], $system_setting['position_ids']) ? 'selected' : '' }}>
                                                                    {{ $data['position_name'] }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        <small id="error_{{ $system_setting['name'] }}" class="text-danger"></small>
                                                    </div>
                                                @endif
                                            @else
                                                @if (in_array($system_setting['kind'], [SETTING_COMPANY_NAME, SETTING_HEADQUARTERS_ADDRESS, SETTING_EMAIL_ADDRESS, SETTING_WEBSITE_ADDRESS, SETTING_HOTLINE, SETTING_ZALO, SETTING_FACEBOOK]))
                                                    <div class="form-group">
                                                        <input type="text" class="form-control" name="{{ $system_setting['name'] }}" value="{{ $system_setting['value'] }}">
                                                        <small id="error_{{ $system_setting['name'] }}" class="text-danger"></small>
                                                    </div>
                                                @endif
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $('.select2').each(function() {
        $(this).select2({
            dropdownParent: $(this).parent(),
        });
    });
</script>
