<div class="blogapp-content">
    <div class="blogapp-detail-wrap">
        <div class="blog-body">
            <div data-simplebar class="nicescroll-bar">
                <div class="container-fluid" style="min-height: 750px">
                    <div class="row">
                        <div class="col-xxl-3 col-lg-4">
                            <div class="content-aside">
                                <h5 class="">Thêm áp giá</h5>
                                <div class="card card-border">
                                    <div class="card-body">
                                        <form class="edit-post-form">
                                            <div class="form-group">
                                                <label class="form-label" for="shipment_code">Mã
                                                    shipment</label>
                                                <input type="text" class="form-control" id="shipment_code">
                                                <small class="text-danger" id="shipment_code_err"></small>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label" for="set_amount">Số tiền</label>
                                                <input type="text" class="form-control text-number" id="set_amount"
                                                    placeholder="vd: 10,000" value="0">
                                                <small class="text-danger" id="set_amount_err"></small>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <button type="button" id="add_amount_origin" onclick="onCreateAmountOriginShipment()"
                                    class="btn btn-primary btn-block mt-3 mb-3">
                                    Xác nhận
                                </button>
                            </div>
                        </div>
                        <div class="col-xxl-9 col-lg-8">
                            <div class="">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label class="form-label">Chọn khoảng thời gian *</label>
                                            <input type="text" name="report_shipment_daterange" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-sm-8">
                                        <div class="form-group">
                                            <label class="form-label">Tìm kiếm</label>
                                            <input type="text" name="shipment_keywords" class="form-control"
                                                placeholder="Nhập mã shipment bạn muốn tìm kiếm">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="">
                                <x-spinner id="loading_show_table_content" />
                                <div id="show_table_content">
                                    @include('manage.admin.system.set-amount-origin-shipment.paginate')
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function() {
        $('.select2').each(function() {
            $(this).select2({
                dropdownParent: $(this).parent(),
            });
        });

        $('input.text-number').on('input', function(e) {
            let val = $(this).val();
            $(this).val(formatNumber(val));
        });

        $('input[name="report_shipment_daterange"]').daterangepicker({
            opens: 'left',
            startDate: moment().subtract(3, 'months').startOf('month'),
            endDate: moment().endOf('month'),
            locale: {
                format: 'DD/MM/YYYY',
                applyLabel: "Áp dụng",
                cancelLabel: "Hủy",
                customRangeLabel: "Tùy chỉnh",
                daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                monthNames: [
                    "Tháng 1",
                    "Tháng 2",
                    "Tháng 3",
                    "Tháng 4",
                    "Tháng 5",
                    "Tháng 6",
                    "Tháng 7",
                    "Tháng 8",
                    "Tháng 9",
                    "Tháng 10",
                    "Tháng 11",
                    "Tháng 12",
                ],
            }
        }, function(start, end, label) {
            $('#loading_show_table_content').addClass('d-block');
            $('#loading_show_table_content').removeClass('d-none');
            page = 1;
            filters = {
                shipment_branch_id: $('[name="shipment_branch_id"]').val(),
                shipment_status: $('[name="shipment_status"]').val(),
                shipment_payment_status: $('[name="shipment_payment_status"]').val(),
                keywords: $('[name="shipment_keywords"]').val(),
                date_range: {
                    start_date: $('input[name="report_shipment_daterange"]').data('daterangepicker')
                        .startDate.format('DD-MM-YYYY') ?? null,
                    end_date: $('input[name="report_shipment_daterange"]').data('daterangepicker')
                        .endDate.format('DD-MM-YYYY') ?? null
                },
            };
            onPagination(`${show_page_url}/pagination`);
        });
    });
</script>
