<div class="table-responsive">
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col">#</th>
                <th scope="col">Tên dịch vụ</th>
                <th scope="col">Loại dịch vụ</th>
                <th scope="col">Trạng thái</th>
                <th scope="col">Khối lượng thể tích (DW)</th>
                <th scope="col"></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($services as $service)
                <tr>
                    <th scope="row">{{ $loop->iteration }}</th>
                    <td>{{ $service['service_name'] }}</td>
                    <td>{{ $service['promotion_name'] }}</td>
                    <td>{{ $service['active_name'] }}</td>
                    <td>{{ formatNumber($service['service_volumetric_mass']) }}</td>
                    <td>
                        <div class="d-flex align-items-center">
                            <x-buttons.btn-link-edit click="onEditService({{ $service['service_id'] }})"/>
                            <x-buttons.btn-link-delete click="onDeleteService({{ $service['service_id'] }})"/>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $services->links('components.pagination') }}
</div>
