<div class="table-responsive">
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col">#</th>
                <th scope="col">Dịch vụ</th>
                <th scope="col">Mô tả</th>
                <th scope="col">Điều kiện</th>
                <th hidden scope="col">Giá phụ thu</th>
                <th scope="col"></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($service_surcharge_fees as $item)
                <tr>
                    <th scope="row">{{ $loop->iteration }}</th>
                    <td>{{ $item['service']['service_name'] }}</td>
                    <td>{{ $item['surcharge_name'] }}</td>
                    <td>{{ $item['condition_type'] == 0 ? '<' : '>' }} {{ $item['condition_value'] }} kg</td>
                    <td hidden>{{ formatNumber($item['amount']) }}</td>
                    <td>
                        <div class="d-flex align-items-center">
                            <x-buttons.btn-link-edit
                                click="onEditServiceSurchargeFee({{ $item['service_surcharge_fee_id'] }})" />
                            <x-buttons.btn-link-delete
                                click="onDeleteServiceSurchargeFee({{ $item['service_surcharge_fee_id'] }})" />
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $service_surcharge_fees->links('components.pagination') }}
</div>
