<div class="table-responsive">
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col">ID</th>
                <th scope="col">Postcode</th>
                <th scope="col">Dịch vụ</th>
                <th scope="col">Zone</th>
                <th scope="col">Town</th>
                <th scope="col">Country</th>
                <th scope="col">State</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($remote as $item)
                <tr>
                    <th scope="row">{{ $item['town_id'] }}</th>
                    <td>{{ $item['town_postal_code'] }}</td>
                    <td>{{ $item['service']['service_name'] ?? '' }}</td>
                    <td>{{ $item['town_zone_code'] }}</td>
                    <td>{{ $item['town_name'] }}</td>
                    <td>{{ $item['country']['country_name'] }}-{{ $item['country']['country_code'] }}</td>
                    <td>{{ isset($item['state_id']) ? $item['state']['state_name'] . '-' . $item['state']['state_code'] : '' }}</td>
                    <td>
                        <div class="d-flex align-items-center">
                            <x-buttons.btn-link-edit click="onEditRemote({{ $item['town_id'] }})"/>
                            <x-buttons.btn-link-delete click="onDeleteRemote({{ $item['town_id'] }})"/>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $remote->links('components.pagination') }}
</div>
