<div class="table-responsive">
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col">#</th>
                <th scope="col">Tên bảng giá</th>
                <th scope="col">Ngày sử dụng</th>
                <th scope="col">Trạng thái</th>
                <th scope="col"></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($price_list as $item)
                <tr>
                    <th scope="row">{{ $loop->iteration }}</th>
                    <td>{{ $item['price_list_title'] }}</td>
                    <td>{{ $item['date_range_flg'] == DATE_RANGE_NO_LIMIT ? 'Không giới hạn' 
                    : formatDate($item['price_list_start_date']) . ' đến ' . formatDate($item['price_list_end_date']) }}</td>
                    <td>{{ $item['active_name'] }}</td>
                    <td>
                        <div class="d-flex align-items-center">
                            <x-buttons.btn-link-view click="onLoadPageEditPriceList({{ $item['price_list_id'] }})"/>
                            <x-buttons.btn-link-delete click="onDeletePriceList({{ $item['price_list_id'] }})"/>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $price_list->links('components.pagination') }}
</div>
