<div class="blogapp-content">
    <div class="blogapp-detail-wrap">
        <div class="blog-body">
            <div data-simplebar class="nicescroll-bar">
                <div class="container-fluid">
                    <form class="mb-10">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex flex-row">
                                <a class="btn btn-icon btn-flush-dark btn-rounded flush-soft-hover mb-0"
                                    href="javascript:void(0);" onclick="onLoadPageSettingImportExcelPriceList()">
                                    <span class="icon">
                                        <span class="feather-icon fs-2">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                class="feather feather-chevron-left">
                                                <polyline points="15 18 9 12 15 6"></polyline>
                                            </svg>
                                        </span>
                                    </span>
                                </a>
                                <a class="mt-2" href="javascript:void(0);"
                                    onclick="onLoadPageSettingImportExcelPriceList()">
                                    <h5>Quay lại</h5>
                                </a>
                            </div>
                            <button type="button" id="create_new_price_list_setting"
                                onclick="onCreatePriceListSettingImportExcel()" class="btn btn-primary mb-0">
                                Lưu lại cài đặt
                            </button>
                        </div>
                        <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                            <span>Mẫu import excel</span>
                        </div>
                        <div class="row gx-3">
                            <ul class="list-group">
                                <a class="list-group-item d-flex justify-content-between align-items-center"
                                    href="{{ asset('assets/file/mau_setting_import_excel_bang_gia_theo_quoc_gia.xlsx') }}"
                                    target="_blank">
                                    Mẫu setting import excel bảng giá theo quốc gia
                                    <span class="badge bg-primary rounded-pill">
                                        <i class="fa fa-download" aria-hidden="true"></i>
                                    </span>
                                </a>
                                <a class="list-group-item d-flex justify-content-between align-items-center"
                                    href="{{ asset('assets/file/mau_setting_import_excel_bang_gia_theo_tieu_bang.xlsx') }}"
                                    target="_blank">
                                    Mẫu setting import excel bảng giá theo state
                                    <span class="badge bg-primary rounded-pill">
                                        <i class="fa fa-download" aria-hidden="true"></i>
                                    </span>
                                </a>
                                <a class="list-group-item d-flex justify-content-between align-items-center"
                                    href="{{ asset('assets/file/mau_setting_import_excel_bang_gia_theo_thanh_pho.xlsx') }}"
                                    target="_blank">
                                    Mẫu setting import excel bảng giá theo city
                                    <span class="badge bg-primary rounded-pill">
                                        <i class="fa fa-download" aria-hidden="true"></i>
                                    </span>
                                </a>
                                <a class="list-group-item d-flex justify-content-between align-items-center"
                                    href="{{ asset('assets/file/mau_setting_import_excel_bang_gia_theo_postcode.xlsx') }}"
                                    target="_blank">
                                    Mẫu setting import excel bảng giá theo post code
                                    <span class="badge bg-primary rounded-pill">
                                        <i class="fa fa-download" aria-hidden="true"></i>
                                    </span>
                                </a>
                            </ul>
                        </div>
                        <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                            <span>Chọn dịch vụ và loại bảng giá</span>
                        </div>
                        <div class="row gx-3">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="form-label">Dịch vụ *</label>
                                    <select class="form-select select2 select2-multiple"
                                        id="price_list_zone_service_ids" multiple>
                                        @foreach ($services as $service)
                                            <option value="{{ $service['service_id'] }}">
                                                {{ $service['service_name'] }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="form-label">Loại bảng giá *</label>
                                    <select class="form-select" id="price_list_zone_type">
                                        <option value="{{ SUB_CHILD_PRICE_LIST_TYPE_COUNTRY }}">Theo quốc gia</option>
                                        <option value="{{ SUB_CHILD_PRICE_LIST_TYPE_STATE }}">Theo state</option>
                                        <option value="{{ SUB_CHILD_PRICE_LIST_TYPE_CITY }}">Theo thành phố</option>
                                        <option value="{{ SUB_CHILD_PRICE_LIST_TYPE_POST_CODE }}">Theo post code
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6" id="form_price_list_zone_excel_file">
                                <div class="form-group">
                                    <label class="form-label">Import excel *</label>
                                    <input type="file" id="price_list_zone_excel_file" class="form-control"
                                        accept=".xlsx, .xls">
                                </div>
                            </div>
                            <div class="col-sm-6" id="form_choose_country_id"></div>
                        </div>
                        <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                            <span>Zone</span>
                        </div>
                        <div class="accordion gx-3" id="accordionFormSettingExcelPriceList">
                            <div class="alert alert-danger">
                                <div class="alert-message">
                                    <strong>Lưu ý!</strong>
                                    <p>
                                        - Bạn cần nhập đúng thông tin zone theo mẫu excel để import thành công.
                                    </p>
                                    <p>
                                        - Đối với loại bảng giá theo post code nếu không có trong hệ thống, hệ thống sẽ tự động tạo mới zone.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="{{ asset('assets/js/xlsx.full.min.js') }}"></script>
<script>
    var priceListZoneCountries = @json($countries);
    $('.select2').each(function() {
        $(this).select2({
            dropdownParent: $(this).parent(),
        });
    });
</script>