<div class="table-responsive">
    @php
        $paycash_kind_name = config('constans.constans.payment_cash_kind');
    @endphp
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col">
                    @if (onCheckPositionAccount(SETTING_ADMIN_ACCOUNT, auth()->user()['position_id']))
                        <input class="form-check-input" type="checkbox" id="is_check_all" onclick="onCheckAllPayCash()"
                            {{ $is_check_all ? 'checked' : '' }}>
                    @endif
                    <label class="form-check-label" for="is_check_all">
                        Trạng thái
                    </label>
                </th>
                <th scope="col">Ngày tạo</th>
                <th scope="col">Mã hóa đơn</th>
                <th scope="col">SỐ TIỀN THỰC TẾ DB/ST</th>
                <th scope="col">Kế toán thu</th>
                <th scope="col">Loại</th>
                <th scope="col">Người thanh toán</th>
                <th scope="col">Chuyển khoản</th>
                <th scope="col">Tiền mặt</th>
                <th scope="col">Tổng tiền</th>
                {{-- <th scope="col">Phương thức</th> --}}
                <th scope="col">Ghi chú</th>
                <th scope="col">Bằng chứng</th>
                <th scope="col"></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($paycashs as $item)
                <tr class="{{ $item['active_flg'] == ACTIVE ? '' : 'table-danger' }}">
                    <td>
                        <div class="form-check {{ $item['active_flg'] == ACTIVE ? '' : 'd-none' }}">
                            @if ($item['checked'] == 0 && onCheckPositionAccount(SETTING_ADMIN_ACCOUNT, auth()->user()['position_id']))
                                <input class="form-check-input" type="checkbox" id="{{ $item['code'] }}"
                                    onclick="onChoosePaymentCash('{{ $item['id'] }}')"
                                    {{ $is_check_all || in_array($item['id'], $choosed_paycash) ? 'checked' : '' }}>
                            @endif
                            @if ($item['checked'] == 1)
                                <span class="badge badge-success">Đã duyệt</span>
                            @else
                                <label class="form-check-label" for="{{ $item['code'] }}">
                                    Chưa duyệt
                                </label>
                            @endif

                        </div>
                    </td>
                    <td>
                        {{ isset($item['payment_at']) ? formatDate($item['payment_at']) : 'Đơn thanh toán trước 6/11' }}
                    </td>
                    <td>
                        @switch($item['kind'])
                            @case(0)
                                <a class="fw-bold text-primary" target="_blank"
                                    href="{{ route('shipments.detail.show', ['shipment_code' => $item['code']]) }}">
                                    {{ $item['code'] }}
                                </a>
                            @break

                            @case(1)
                                <a class="fw-bold text-primary"
                                    href="{{ route('debit.detail', ['debit_code' => $item['code']]) }}">
                                    {{ $item['code'] }}
                                </a>
                                <a href="{{ route('debit.fwd.export.bill.debit', ['debit_no' => $item['code']]) }}"
                                    class="btn btn-icon btn-social btn-primary ms-1">
                                    <span class="icon"><i class="fas fa-download"></i></span>
                                </a>
                            @break

                            @case(2)
                                <a class="fw-bold text-primary"
                                    href="{{ route('statement.detail.display', ['statement_code' => $item['code']]) }}">
                                    {{ $item['code'] }}
                                </a>
                                <a href="{{ route('statement.detail.export', ['statement_code' => $item['code']]) }}"
                                    target="_blank" class="btn btn-icon btn-social btn-primary ms-1"><span class="icon"><i
                                            class="fas fa-download"></i></span></a>
                            @break

                            @default
                        @endswitch
                    </td>
                    <td>
                        @php
                            $check_difference = $item['amount'] != $item['origin_amount'];
                            $check_icon = $check_difference ? 'fas fa-exclamation-circle text-danger' : '';
                            $check_text = $check_difference ? 'Giá tiền có sự trên lệch' : '';
                        @endphp
                        @switch($item['kind'])
                            @case(1)
                                {{ formatNumber($item['origin_amount']) }} <i title="{{ $check_text }}"
                                    class="{{ $check_icon }}"></i>
                            @break

                            @case(2)
                                {{ formatNumber($item['origin_amount']) }} <i title="{{ $check_text }}"
                                    class="{{ $check_icon }}"></i>
                            @break

                            @default
                        @endswitch
                    </td>
                    <td>[{{ $item['creator_code'] }}] {{ $item['creator_name'] }} </td>
                    <td>{{ $paycash_kind_name[$item['kind']] ?? 'Không xác định' }}</td>
                    <td>
                        @include('components.badges-position-name', [
                            'position_id' => $item['customer_position_id'],
                        ])
                        {{ onCheckPositionAccount(SETTING_FWD_ACCOUNT, $item['customer_position_id']) ? $item['customer_company'] : $item['customer_name'] }}
                    </td>
                    @if ($item['active_flg'] == ACTIVE)
                        <td>{{ formatNumber($item['amount_bank']) }}</td>
                        <td>{{ formatNumber($item['amount_cash']) }}</td>
                        <td>{{ formatNumber($item['amount']) }}</td>
                        {{-- <td>{{ $item['payment_method'] == CASH ? 'Tiền mặt' : 'Chuyển khoản' }}</td> --}}
                        <td>{{ $item['checked_note'] }}</td>
                        <td>
                            @foreach (onConvertStrArrImage($item['images']) as $image)
                                <a class="p-2" href="{{ asset($image) }}" target="_blank"><i
                                        class="fas fa-image"></i></a>
                            @endforeach
                        </td>
                        @if (onCheckPositionAccount(SETTING_ADMIN_ACCOUNT, auth()->user()['position_id']))
                            <td>
                                @if ($item['checked'] == 0)
                                    <button class="btn btn-primary btn-sm m-1" data-bs-toggle="tooltip"
                                        data-bs-placement="bottom" data-bs-title="Duyệt đơn và chia tiền thanh toán"
                                        onclick="showModalCheckedPayment({{ $item['id'] }}, {{ $item['amount'] }}, {{ $item['amount_cash'] }}, {{ $item['amount_bank'] }})"><i
                                            class="fas fa-check"></i></button>
                                @endif
                                @if ($item['checked'] == 1)
                                    <button class="btn btn-warning btn-sm m-1" data-bs-toggle="tooltip"
                                        data-bs-placement="bottom" data-bs-title="Hoàn lại trạng thái đơn"
                                        onclick="onRefundCheckedPayment({{ $item['id'] }})"><i
                                            class="fas fa-undo"></i></button>
                                @endif
                                <button class="btn btn-danger btn-sm m-1"
                                    title="hoàn đơn về trạng thái chưa thanh toán"
                                    onclick="onRemoveCheckedPayment({{ $item['id'] }}, {{ $item['active_flg'] }})">
                                    <i class="fas fa-exclamation-circle"></i></button>
                            </td>
                        @endif
                    @else
                        <td colspan="5" class="fw-bold">{{ $item['checked_note'] }}</td>
                        <td><button class="btn btn-danger btn-sm m-1" title="Xóa ghi chú"
                                onclick="onRemoveCheckedPayment({{ $item['id'] }}, {{ $item['active_flg'] }})"><i
                                    class="fas fa-trash"></i></button></td>
                    @endif

                </tr>
            @endforeach
        </tbody>

    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $paycashs->links('components.pagination') }}
</div>
<script>
    $(function() {
        let fwd_cash = @json($chart['fwd_cash']) ?? 0;
        let fwd_bank = @json($chart['fwd_bank']) ?? 0;
        let sale_cash = @json($chart['sale_cash']) ?? 0;
        let sale_bank = @json($chart['sale_bank']) ?? 0;

        $('#content_chart').html('');
        var pub_chart = null;
        if (pub_chart) {
            pub_chart.destroy();
        }

        var options = {
            series: [fwd_cash, fwd_bank, sale_cash, sale_bank],
            chart: {
                type: 'pie',
            },
            colors: ['#ff3d3d', '#007D88', '#FFFF00', '#00FF00'],
            labels: ['Fwd tiền mặt', 'Fwd chyển khoản', 'Sale tiền mặt', 'Sale chyển khoản'],
            legend: {
                position: 'bottom' // Đặt labels ở phía dưới
            },
            tooltip: {
                y: {
                    formatter: function(value) {
                        return value
                            .toLocaleString(); // Sử dụng hàm formatNumber đã định nghĩa trước đó
                    }
                }
            },
            responsive: [{
                breakpoint: 480,
                options: {
                    chart: {
                        width: 200
                    },
                    legend: {
                        position: 'bottom'
                    }
                }
            }]
        };

        pub_chart = new ApexCharts(document.querySelector("#content_chart"), options);
        pub_chart.render();

        let total_cash = fwd_cash + fwd_bank + sale_cash + sale_bank;

        $('#fwd_cash').html(fwd_cash.toLocaleString() + ' vnd');
        $('#fwd_bank').html(fwd_bank.toLocaleString() + ' vnd');
        $('#sale_cash').html(sale_cash.toLocaleString() + ' vnd');
        $('#sale_bank').html(sale_bank.toLocaleString() + ' vnd');
        $('#total_cash').html(total_cash.toLocaleString() + ' vnd');

    });
</script>
