<div class="blogapp-content">
    <div class="blogapp-detail-wrap">
        <div class="blog-body">
            <div data-simplebar class="nicescroll-bar">
                <div class="container-fluid" style="min-height: 750px">
                    <div class="row">
                        <div class="col-xxl-12 col-lg-12">
                            <div class="content-aside row">
                                <div class="col-md-6">
                                    <div class="card card-border">
                                        <div class="card-body">
                                            <div class="" id="content_chart"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 row">
                                    <div class="col-md-6">
                                        <div class="card card-wth-line">
                                            <div class="card-line bg-danger"></div>
                                            <div class="card-body">
                                                <h4 class="card-title" id="fwd_cash"></h4>
                                                <p class="card-text">Fwd tiền mặt</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="card card-wth-line ">
                                            <div class="card-line bg-primary"></div>
                                            <div class="card-body">
                                                <h4 class="card-title" id="fwd_bank"></h4>
                                                <p class="card-text">Fwd chuyển khoản</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="card card-wth-line">
                                            <div class="card-line bg-warning"></div>
                                            <div class="card-body">
                                                <h4 class="card-title" id="sale_cash"></h4>
                                                <p class="card-text">Sale tiền mặt</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="card card-wth-line ">
                                            <div class="card-line bg-success"></div>
                                            <div class="card-body">
                                                <h4 class="card-title" id="sale_bank"></h4>
                                                <p class="card-text">Sale chuyển khoản</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="text-center text-primary fw-bold fs-5">Tổng: <span
                                            id="total_cash"></span> </div>
                                    <div class="">
                                        <button type="button" id="btn_confirm_pay_cash"
                                            onclick="onExportExcelCheckPayment()" class="btn btn-primary w-100 mt-3">
                                            <i class="fas fa-file-excel"></i> Xuất file excel
                                        </button>
                                        @if (onCheckPositionAccount(SETTING_ADMIN_ACCOUNT, auth()->user()['position_id']))
                                            <button type="button" id="btn_confirm_pay_cash"
                                                onclick="onConfirmPaymentCash()" class="btn btn-primary w-100 mt-3">
                                                <i class="fas fa-check-circle"></i> Duyệt lệnh
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-12 col-lg-12">
                            <div class="">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="form-label">Chọn khoảng thời gian *</label>
                                            <input type="text" name="payment_cash_daterange" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="form-label">Trạng thái</label>
                                            <select class="form-control" name="pay_cash_checked">
                                                <option value="">Tất cả</option>
                                                <option value="0">Chờ duyệt</option>
                                                <option value="1">Đã duyệt</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="form-label">Chức vụ</label>
                                            <select class="form-select" name="users_position_id" id="users_position_id">
                                                <option selected value="">Tất cả</option>
                                                @foreach ($positions as $position)
                                                    <option value="{{ $position['position_id'] }}">
                                                        {{ $position['position_name'] }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="form-label">Phương thức</label>
                                            <select class="form-control" name="payment_method" id="payment_method">
                                                <option value="">Tất cả</option>
                                                <option value="{{ CASH }}">Tiền mặt</option>
                                                <option value="{{ BANK }}">Chuyển khoản</option>
                                                <option value="2">Tiền mặt & Chuyển khoản</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="form-label">Loại đơn</label>
                                            <select class="form-control" name="bill_type" id="bill_type">
                                                <option value="">Tất cả</option>
                                                <option value="{{ SHIPMENT }}">shipment</option>
                                                <option value="{{ DEBIT }}">debit</option>
                                                <option value="{{ STATEMENT }}">statement</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label class="form-label">Chênh lệch giá tiền</label>
                                            <select class="form-control" name="difference_amount"
                                                id="difference_amount">
                                                <option value="">Tất cả</option>
                                                <option value="1">Có chênh lệch</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="form-group">
                                            <label class="form-label">Tìm kiếm</label>
                                            <input type="text" name="payment_cash_keywords" class="form-control"
                                                placeholder="Nhập mã bill bạn muốn tìm kiếm">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="">
                                <x-spinner id="loading_show_table_content" />
                                <div id="show_table_content">
                                    @include('manage.admin.system.manage-pay-cash.paginate')
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modalConfirmOneCheckedPayment" data-bs-backdrop="static" data-bs-keyboard="false"
        tabindex="-1" aria-labelledby="modalConfirmOneCheckedPaymentLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-primary">
                    <h1 class="modal-title fs-5 fw-bold text-white" id="modalConfirmOneCheckedPaymentLabel">
                        Duyệt lệnh thanh toán
                    </h1>
                    <button type="button" class="btn btn-danger btn-floating" data-bs-dismiss="modal"
                        aria-label="Close">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <input hidden type="text" class="form-control" id="checked_id">
                    <div class="mb-3">
                        <label class="form-label">Tổng tiền </label>
                        <input type="text" class="form-control" id="checked_total_amount" disabled>
                        <div id="checked_total_amount_err" class="form-text text-danger"></div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Chuyển khoản (<span id="label_bank"></span>) </label>
                        <input type="text" class="form-control" id="checked_amount_bank">
                        <div id="checked_amount_bank_err" class="form-text text-danger"></div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tiền mặt (<span id="label_cash"></span>)</label>
                        <input type="text" class="form-control" id="checked_amount_cash">
                        <div id="checked_amount_cash_err" class="form-text text-danger"></div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Ghi chú </label>
                        <textarea class="form-control" id="checked_note" rows="3"></textarea>
                        <div id="checked_note_err" class="form-text text-danger"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" onclick="onConfirmOneCheckedPayment()">Xác
                        nhận</button>
                </div>
            </div>
        </div>
    </div>


</div>
<script>
    $(function() {
        $('.select2').each(function() {
            $(this).select2({
                dropdownParent: $(this).parent(),
            });
        });

        $('input.text-number').on('input', function(e) {
            let val = $(this).val();
            $(this).val(formatNumber(val));
        });

        $('input[name="payment_cash_daterange"]').daterangepicker({
            opens: 'left',
            startDate: moment().subtract(3, 'months').startOf('month'),
            endDate: moment().endOf('month'),
            locale: {
                format: 'DD/MM/YYYY',
                applyLabel: "Áp dụng",
                cancelLabel: "Hủy",
                customRangeLabel: "Tùy chỉnh",
                daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                monthNames: [
                    "Tháng 1",
                    "Tháng 2",
                    "Tháng 3",
                    "Tháng 4",
                    "Tháng 5",
                    "Tháng 6",
                    "Tháng 7",
                    "Tháng 8",
                    "Tháng 9",
                    "Tháng 10",
                    "Tháng 11",
                    "Tháng 12",
                ],
            }
        }, function(start, end, label) {
            $('#loading_show_table_content').addClass('d-block');
            $('#loading_show_table_content').removeClass('d-none');
            filters = {
                checked: $('[name="pay_cash_checked"]').val(),
                position_id: $('[name="users_position_id"]').val(),
                payment_method: $('[name="payment_method"]').val(),
                keywords: $('[name="payment_cash_keywords"]').val(),
                difference_amount: $('[name="difference_amount"]').val(),
                date_range: {
                    start_date: $('input[name="payment_cash_daterange"]').data('daterangepicker')
                        .startDate.format('DD-MM-YYYY') ?? null,
                    end_date: $('input[name="payment_cash_daterange"]').data('daterangepicker')
                        .endDate.format('DD-MM-YYYY') ?? null
                },
                is_check_all: $('#is_check_all').is(':checked'),
                choosed_paycash: typeof choosed_paycash !== "undefined" ? choosed_paycash : null
            }
            onPagination(`${show_page_url}/pagination`);
        });


    });
</script>
