<div class="table-responsive">
    @php
        $paycash_kind_name = config('constans.constans.payment_cash_kind');
    @endphp
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col">Trạng thái</th>
                <th scope="col">Ngày tạo</th>
                <th scope="col">Mã hóa đơn</th>
                <th scope="col">Loại</th>
                <th scope="col">Người thanh toán</th>
                <th scope="col">Loại tài khoản</th>
                <th scope="col">Số tiền</th>
                <th scope="col">Phương thức</th>
                <th scope="col">Kế toán thu</th>
                <th scope="col">Biện lai</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($data_excel as $item)
                <tr>
                    <td>
                        <div class="form-check">
                            {{ $item['checked'] == 1 ? 'Đã duyệt' : 'Chưa xác nhận' }}
                        </div>
                    </td>
                    <td>
                        {{ isset($item['payment_at']) ? formatDate($item['payment_at']) : 'Đơn thanh toán trước 6/11' }}
                    </td>
                    <td>{{ $item['code'] }}</td>
                    <td>{{ $paycash_kind_name[$item['kind']] ?? 'Không xác định' }}</td>
                    <td>
                        {{ $item['customer_name'] }}
                    </td>
                    <td>
                        @include('components.badges-position-name', [
                            'position_id' => $item['customer_position_id'],
                        ])
                    </td>
                    <td>{{ formatNumber($item['amount']) }}</td>
                    <td>{{ $item['payment_method'] == CASH ? 'Tiền mặt' : 'Chuyển khoản' }}</td>
                    <td>[{{ $item['creator_code'] }}] {{ $item['creator_name'] }} </td>
                    @foreach (onConvertStrArrImage($item['images']) as $image)
                        <td><a href="{{ $image }}">Biên lai</a></td>
                    @endforeach
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
