<div class="table-responsive" style="min-height:500px">
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th style="background-color: #eeff00; font-weight: bold; color: #FFF">STT</th>
                <th style="background-color: #eeff00; font-weight: bold; color: #FFF">Tài khoản</th>
                <th style="background-color: #eeff00; font-weight: bold; color: #FFF">Mã người dùng</th>
                <th style="background-color: #eeff00; font-weight: bold; color: #FFF">Công ty</th>
                <th style="background-color: #eeff00; font-weight: bold; color: #FFF">Số điện thoại</th>
                <th style="background-color: #eeff00; font-weight: bold; color: #FFF">Công nợ</th>
                <th style="background-color: #eeff00; font-weight: bold; color: #FFF">Hạn mức nợ</th>
                <th style="background-color: #eeff00; font-weight: bold; color: #FFF">Hạn mức còn lại</th>
                <th style="background-color: #eeff00; font-weight: bold; color: #FFF">Logo</th>
                <th style="background-color: #eeff00; font-weight: bold; color: #FFF">Sale quản lý</th>
                <th style="background-color: #eeff00; font-weight: bold; color: #FFF">Năm ký hợp đồng</th>
                <th style="background-color: #eeff00; font-weight: bold; color: #FFF">Ngày tạo</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($data_excel as $user)
                <tr class="text-nowrap">
                    <th scope="row">{{ $loop->iteration }}</th>
                    <td>
                        {{ $user['user_name'] }}
                        @if ($user['active_flg'] == INACTIVE)
                            [Tài khoản bị khoá]
                        @endif
                    </td>
                    <td>{{ $user['user_code'] }}</td>
                    <td>{{ $user['user_company_name'] }}</td>
                    <td>{{ $user['user_phone'] }}</td>
                    <td>{{ $user['user_debit_type_name'] }}</td>
                    <td>
                        @if ($user['position']['limit_amount_flg'] == NO_LIMIT)
                            Không giới hạn
                        @else
                            {{ formatNumber($user['user_limit_amount_for_sale']) }}đ
                        @endif
                    </td>
                    <td>{{ formatNumber($user['user_remaining_limit']) }}đ</td>
                    <td class="text-center">
                        @if (isset($user['user_logo']))
                            <a href="{{ isset($user['user_logo']) ? asset($user['user_logo']) : 'javascript:void(0);' }}"
                                target="_blank" rel="noopener noreferrer">
                                logo
                            </a>
                        @endif
                    </td>
                    <td>
                        {{ $user['saleLinkFwd']['saleAccount']['user_contact_name'] ?? '' }}
                    </td>
                    <td>
                        {{ $user['contract_years'] ?? '' }}
                    </td>
                    <td>
                        {{ formatDate($user['created_at']) }}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
