<div class="blogapp-content">
    <div class="blogapp-detail-wrap">
        <div class="blog-body">
            <div data-simplebar class="nicescroll-bar">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-3 col-lg-4">
                            <div class="content-aside">
                                <div class="card card-border">
                                    <div class="card-body">
                                        <form class="edit-post-form">
                                            <div class="form-group">
                                                <label class="form-label">Chọn tài khoản *</label>
                                                <select class="form-select select2" name="user_id" id="user_id">
                                                    <option selected value="">Chọn tài khoản giảm giá</option>
                                                    @foreach ($users as $user)
                                                        <option value="{{ $user['user_id'] }}">
                                                            {{ $user['user_name'] }} - {{ $user['user_company_name'] }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <small id="error_user_id" class="text-danger"></small>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label">Chọn dịch vụ *</label>
                                                <select class="form-select select2" name="service_id" id="service_id">
                                                    <option selected value="">Chọn dịch vụ giảm giá</option>
                                                    @foreach ($services as $service)
                                                        <option value="{{ $service['service_id'] }}">
                                                            {{ $service['service_name'] }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <small id="error_service_id" class="text-danger"></small>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label">Chọn khoảng thời gian *</label>
                                                <input type="text" name="discount_user_daterange" class="form-control">
                                                <small id="error_discount_user_daterange" class="text-danger"></small>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label">Ghi chú</label>
                                                <input type="text" name="discount_note" class="form-control"
                                                    placeholder="Nhập ghi chú">
                                                <small id="error_discount_note" class="text-danger"></small>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label">Mức kg</label>
                                                <div id="form_discount_user_kg_levels"></div>
                                                <div class="text-center">
                                                    <button type="button" class="btn btn-primary" id="add_discount_user_kg_level">
                                                        <i class="fa fa-plus"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <button type="button" id="save_discount_user" onclick="saveDiscountUser()"
                                    class="btn btn-primary btn-block mt-3 mb-3">
                                    Xác nhận
                                </button>
                                <button onclick="reloadOnePageManage()"
                                    class="btn btn-outline-secondary btn-block mb-3">Tải lại trang</button>
                            </div>
                        </div>
                        <div class="col-xxl-9 col-lg-8">
                            <x-spinner id="loading_show_table_content" />
                            <div id="show_table_content">
                                @include('manage.admin.system.discount-user.discount-users-pagination')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function() {
        $('.select2').each(function() {
            $(this).select2({
                dropdownParent: $(this).parent(),
            });
        });

        $('input[name="discount_user_daterange"]').daterangepicker({
            opens: 'left',
            startDate: moment().subtract(3, 'months').startOf('month'),
            endDate: moment().endOf('month'),
            locale: {
                format: 'DD/MM/YYYY',
                applyLabel: "Áp dụng",
                cancelLabel: "Hủy",
                customRangeLabel: "Tùy chỉnh",
                daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                monthNames: [
                    "Tháng 1",
                    "Tháng 2",
                    "Tháng 3",
                    "Tháng 4",
                    "Tháng 5",
                    "Tháng 6",
                    "Tháng 7",
                    "Tháng 8",
                    "Tháng 9",
                    "Tháng 10",
                    "Tháng 11",
                    "Tháng 12",
                ],
            }
        }, function(start, end, label) {
            
        });
    });
</script>
