<div class="table-responsive">
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col">#</th>
                <th scope="col">Account ID</th>
                <th scope="col">Công ty</th>
                <th scope="col">Dịch vụ</th>
                <th scope="col">Ngày bắt đầu</th>
                <th scope="col">Ngày kết thúc</th>
                <th scope="col">Ghi chú</th>
                <th scope="col"></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($discount_users as $discount_user)
                <tr>
                    <th scope="row">{{ $loop->iteration }}</th>
                    <td>{{ $discount_user['user']['user_code'] }}</td>
                    <td>{{ $discount_user['user']['user_company_name'] }}</td>
                    <td>{{ $discount_user['service']['service_name'] }}</td>
                    <td>{{ formatDate($discount_user['discount_start_date']) }}</td>
                    <td>{{ formatDate($discount_user['discount_end_date']) }}</td>
                    <td>{{ $discount_user['discount_note'] }}</td>
                    <td>
                        <div class="d-flex align-items-center">
                            <x-buttons.btn-link-edit click="onEditDiscountUser({{ $discount_user['discount_user_id'] }})"/>
                            <x-buttons.btn-link-delete click="onDeleteDiscountUser({{ $discount_user['discount_user_id'] }})"/>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $discount_users->links('components.pagination') }}
</div>
