@foreach ($countries as $country)
    <div class="col-xxl-3 col-lg-4">
        <div class="card">
            <div class="card-header fw-bold">
                {{ $country['country_name'] }} - {{ $country['country_code'] }}
            </div>
            <div class="card-body">
                <div class="form-group">
                    <select class="form-select select2 select2-multiple select_multiple_services" multiple="multiple"
                        id="{{ $country['country_id'] }}">
                        @foreach ($services as $key_service => $service)
                            <option value="{{ $service['service_id'] }}"
                                {{ collect($country['countriesServices'])->firstWhere('service_id', $service['service_id']) ? 'selected' : '' }}>
                                {{ $service['service_name'] }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
    </div>
@endforeach
<div class="d-flex justify-content-center mt-5">
    {{ $countries->links('components.pagination') }}
</div>
<script>
    $('.select2').each(function() {
        $(this).select2({
            dropdownParent: $(this).parent(),
        });
    });
</script>