<div class="blogapp-content">
    <div class="blogapp-detail-wrap">
        <div class="blog-body">
            <div data-simplebar class="nicescroll-bar">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-3 col-lg-4">
                            <div class="content-aside">
                                <div class="card card-border">
                                    <div class="card-body">
                                        <form class="edit-post-form">
                                            <div class="form-group">
                                                <label class="form-label">Quốc gia *</label>
                                                <select class="form-select select2" name="country_id" id="country_id">
                                                    <option value="">Chọn quốc gia</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country['country_id'] }}">
                                                            {{ $country['country_name'] }} - {{ $country['country_code'] }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <small id="error_country_id" class="text-danger"></small>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label">Tên thành phố *</label>
                                                <input type="text" name="city_name" class="form-control"
                                                    placeholder="Nhập tên thành phố">
                                                <small id="error_city_name" class="text-danger"></small>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label">Post code *</label>
                                                <input type="text" name="city_post_code" class="form-control"
                                                    placeholder="Nhập post code">
                                                <small id="error_city_post_code" class="text-danger"></small>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label">State</label>
                                                <select class="form-select select2" name="state_id" id="state_id">
                                                    <option value="">Chọn state</option>
                                                </select>
                                                <small id="error_state_id" class="text-danger"></small>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label">Trạng thái *</label>
                                                <select class="form-select" name="active_flg">
                                                    <option selected value="{{ ACTIVE }}">Đang hoạt động</option>
                                                    <option value="{{ INACTIVE }}">Dừng hoạt động</option>
                                                </select>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <button type="button" id="save_city" onclick="saveCity()" class="btn btn-primary btn-block mt-3 mb-3">
                                    Xác nhận
                                </button>
                                <button onclick="reloadOnePageManage()" class="btn btn-outline-secondary btn-block mb-3">Tải lại trang</button>
                            </div>
                        </div>
                        <div class="col-xxl-9 col-lg-8">
                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <div class="col-xxl-6 col-lg-6">
                                            <div class="form-group">
                                                <label class="form-label">Quốc gia</label>
                                                <select class="form-select select2" name="cities_country_id" id="cities_country_id">
                                                    <option value="">Tất cả</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country['country_id'] }}">
                                                            {{ $country['country_name'] }} -
                                                            {{ $country['country_code'] }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-lg-6">
                                            <div class="form-group">
                                                <label class="form-label">State/Province</label>
                                                <select class="form-select select2" name="cities_state_id" id="cities_state_id">
                                                    <option value="">Tất cả</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-lg-6">
                                            <div class="form-group">
                                                <label class="form-label">Trạng thái</label>
                                                <select class="form-select" name="cities_active_flg">
                                                    <option value="">Tất cả</option>
                                                    <option value="{{ ACTIVE }}">Đang hoạt động</option>
                                                    <option value="{{ INACTIVE }}">Ngừng hoạt động</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-lg-6">
                                            <div class="form-group">
                                                <label class="form-label">Tìm kiếm</label>
                                                <input type="text" name="cities_keywords" class="form-control"
                                                    placeholder="Nhập nội dung bạn muốn tìm kiếm">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <x-spinner id="loading_show_table_content" />
                                    <div id="show_table_content">
                                        @include('manage.admin.system.city.cities-pagination')
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $('.select2').each(function() {
        $(this).select2({
            dropdownParent: $(this).parent(),
        });
    });
</script>