<div class="table-responsive">
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col">ID</th>
                <th scope="col">Tên thành phố</th>
                <th scope="col">Post code</th>
                <th scope="col">Tên quốc gia</th>
                <th scope="col">State/Province</th>
                <th scope="col">Trạng thái</th>
                <th scope="col"></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($cities as $city)
                <tr>
                    <th scope="row">{{ $city['city_id'] }}</th>
                    <td>{{ $city['city_name'] }}</td>
                    <td>{{ $city['city_post_code'] }}</td>
                    <td>{{ isset($city['country']) ? $city['country']['country_name'] : '' }}</td>
                    <td>{{ isset($city['state']) ? $city['state']['state_name'] : '' }}</td>
                    <td>{{ $city['active_name'] }}</td>
                    <td>
                        <div class="d-flex align-items-center">
                            <x-buttons.btn-link-edit click="onEditCity({{ $city['city_id'] }})"/>
                            <x-buttons.btn-link-delete click="onDeleteCity({{ $city['city_id'] }})"/>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $cities->links('components.pagination') }}
</div>
