<div class="table-responsive">
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col">#</th>
                <th scope="col">Tên chi nhánh</th>
                <th scope="col">Địa chỉ</th>
                <th scope="col">Trạng thái</th>
                <th scope="col">Ngày tạo</th>
                <th scope="col"></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($branchs as $branch)
                <tr>
                    <th scope="row">{{ $loop->iteration }}</th>
                    <td>{{ $branch['branch_name'] }}</td>
                    <td>{{ $branch['branch_description'] }}</td>
                    <td>{{ $branch['active_name'] }}</td>
                    <td>{{ formatFullDate($branch['created_at']) }}</td>
                    <td>
                        <div class="d-flex align-items-center">
                            <x-buttons.btn-link-edit click="onEditBranch({{ $branch['branch_id'] }})"/>
                            <x-buttons.btn-link-delete click="onDeleteBranch({{ $branch['branch_id'] }})"/>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $branchs->links('components.pagination') }}
</div>
