@foreach ($services as $service)
    <div class="col-xxl-4 col-lg-6">
        <div class="card">
            <div class="card-header fw-bold">
                {{ $service['service_name'] }}
                <div class="d-flex">
                    <button class="btn btn-sm btn-info download-weight-conversion" 
                        data-service_id="{{ $service['service_id'] }}" data-service_name="{{ $service['service_name'] }}">
                        Cân nặng
                        <i class="fas fa-download"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <select class="form-select select2 select2-multiple select_multiple_api_labels" multiple="multiple"
                        id="{{ $service['service_id'] }}">
                        @foreach ($api_labels as $key_api_label => $api_label)
                            <option value="{{ $key_api_label }}"
                                {{ isset($service['associateWithService']) && in_array($key_api_label, json_decode($service['associateWithService']['associate_types'], true)) ? 'selected' : '' }}>
                                {{ $api_label }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
    </div>
@endforeach
<div class="d-flex justify-content-center mt-5">
    {{ $services->links('components.pagination') }}
</div>
<script>
    $('.select2').each(function() {
        $(this).select2({
            dropdownParent: $(this).parent(),
        });
    });
</script>