<div class="table-responsive">
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col"></th>
                <th scope="col">Ngày</th>
                <th scope="col">ID Bill</th>
                <th scope="col">Sale Name</th>
                <th scope="col">Hạn mức</th>
                <th scope="col">Nợ hiện tại</th>
                <th scope="col">Cước gốc</th>
                <th scope="col">Thu khách</th>
                <th scope="col">Dịch vụ</th>
                <th scope="col">Thanh toán</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($shipments as $shipment)
                <tr>
                    <th scope="row">
                        <button id="btn_shipment_{{ $shipment->shipment_code }}" onclick="onActionBtnShowClick(this)"
                            class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                            data-bs-toggle="collapse" data-bs-target="#shipment_{{ $shipment->shipment_code }}"
                            aria-expanded="false">
                            <span class="icon">
                                <i class="fa fa-plus"></i>
                            </span>
                        </button>
                    </th>
                    <td>{{ formatDate($shipment['created_at']) }}</td>
                    <td>
                        <a class="fw-bold text-primary" target="_blank"
                            href="{{ route('shipments.detail.show', ['shipment_code' => $shipment['shipment_code']]) }}">
                            {{ $shipment['shipment_code'] }}
                        </a>
                    </td>
                    <td>[{{ $shipment['user_code'] }}] {{ $shipment['user_contact_name'] }}  </td>
                    <td>
                        @if ($shipment['limit_amount_flg'] == NO_LIMIT)
                            Không giới hạn
                        @else
                            {{ $shipment['user_limit_amount_for_sale'] ?? 0 }}
                        @endif
                    </td>
                    <td>{{ $shipment['user_remaining_limit'] }}</td>
                    <td>{{ $shipment['branch_name'] }}</td>
                    <td>{{ number_format($shipment['shipment_amount_original']) }}</td>
                    <td>{{ number_format($shipment['shipment_amount_total_customer']) }}</td>
                    <td>{{ $shipment['service_name'] }}</td>
                    <td>
                        <span class="fw-bold text-{{ $shipment['shipment_payment_status'] == 0 ? 'danger' : 'success' }}">
                            {{ $shipment['shipment_payment_status'] == 0 ? 'Chưa thanh toán' : 'Đã thanh toán' }}
                        </span>
                    </td>
                </tr>
                <tr class="child collapse" id="shipment_{{ $shipment->shipment_code }}">
                    <td class="child" colspan="7">
                        <ul>
                            <li class="mb-3">
                                <span class="dtr-title">Quốc gia: </span> 
                                <span class="dtr-data fw-bold">
                                    {{ $shipment['country_name'] }}
                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Chi nhánh: </span> 
                                <span class="dtr-data fw-bold">
                                    {{ $shipment['branch_name'] }}
                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Người nhận: </span> 
                                <span class="dtr-data fw-bold">
                                    {{ $shipment['receiver_contact_name'] }}
                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Xác thực: </span>
                                @if ($shipment['accountant_status'] == 0)
                                    <span class="dtr-data fw-bold text-secondary">
                                        Đang chờ xác nhận
                                    </span>
                                @elseif($shipment['accountant_status'] == 1)
                                    <span class="dtr-data fw-bold text-success">
                                        Đã xác nhận
                                    </span>
                                @else
                                    <span class="dtr-data fw-bold text-danger">
                                        Đã hủy đơn
                                    </span>
                                    <p><strong>Nguyên nhân hủy: </strong>{{ $shipment['accountant_cancel_note'] }}</p>
                                @endif
                            </li>
                        </ul>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    {{ $shipments->links('components.pagination') }}
</div>
