<div class="blogapp-content">
    <div class="blogapp-detail-wrap">
        <div class="blog-body">
            <div data-simplebar class="nicescroll-bar">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="row">
                                <div class="mb-3 col-sm-4">
                                    <label class="form-lable">Chi nhánh</label>
                                    <select class="form-control select2" name="shipment_branch_id">
                                        <option value="">All</option>
                                        @foreach ($branchs as $key => $branch)
                                            <option value="{{ $branch['branch_id'] }}">
                                                {{ $branch['branch_name'] }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="mb-3 col-sm-4">
                                    <label class="form-lable">Trạng thái</label>
                                    <select class="form-control select2" name="shipment_status">
                                        <option value="">All</option>
                                        @foreach ($shipment_status as $key => $status)
                                            <option value="{{ $key }}">{{ $status }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="mb-3 col-sm-4">
                                    <label class="form-lable">Trạng thái thanh toán</label>
                                    <select class="form-control select2" name="shipment_payment_status">
                                        <option value="">Tất cả</option>
                                        <option value="0">Chưa thanh toán</option>
                                        <option value="1">Đã thanh toán</option>
                                    </select>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label class="form-label">Chọn khoảng thời gian *</label>
                                        <input type="text" name="report_shipment_daterange" class="form-control">
                                    </div>
                                </div>
                                <div class="col-xxl-6 col-lg-6">
                                    <div class="form-group">
                                        <label class="form-label">Tìm kiếm</label>
                                        <input type="text" name="shipment_keywords" class="form-control"
                                            placeholder="Nhập nội dung bạn muốn tìm kiếm">
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label class="form-label">Xuất báo cáo excel</label>
                                        <button class="btn btn-primary w-100" 
                                        id="btn_report_excel_sale" onclick="onReportSaleExcel()">
                                            <i class="fas fa-file-excel"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <x-spinner id="loading_show_table_content" />
                            <div id="show_table_content">
                                @include('manage.admin.system.accountant.shipments-paginate')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function() {
        $('.select2').each(function() {
            $(this).select2({
                dropdownParent: $(this).parent(),
            });
        });

        $('input[name="report_shipment_daterange"]').daterangepicker({
            opens: 'left',
            startDate: moment().subtract(3, 'months').startOf('month'),
            endDate: moment().endOf('month'),
            locale: {
                format: 'DD/MM/YYYY',
                applyLabel: "Áp dụng",
                cancelLabel: "Hủy",
                customRangeLabel: "Tùy chỉnh",
                daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                monthNames: [
                    "Tháng 1",
                    "Tháng 2",
                    "Tháng 3",
                    "Tháng 4",
                    "Tháng 5",
                    "Tháng 6",
                    "Tháng 7",
                    "Tháng 8",
                    "Tháng 9",
                    "Tháng 10",
                    "Tháng 11",
                    "Tháng 12",
                ],
            }
        }, function(start, end, label) {
            
        });
    });
</script>